; -- TeXmacs.iss --
; Inno Setup configuration file for the compilation of the 
; Windows TeXmacs installer

[Setup]
AppName=TeXmacs
AppVerName=Texmacs
DefaultDirName={commonpf32}\TeXmacs
DefaultGroupName=TeXmacs
;denis begin
VersionInfoTextVersion=1.99.20
AppPublisher=MAGIX
AppPublisherURL=https://www.texmacs.org/
AppVersion=1.99.20
LicenseFile=..\..\..\distr\TeXmacs-Windows\LICENSE
;denis end

UninstallDisplayIcon={app}\TeXmacs.ico
OutputDir=..\..\..\distr\windows
OutputBaseFilename=TeXmacs-1.99.20-installer
; SourceDir=../..
ChangesAssociations=yes

WizardImageFile=TeXmacs-large.bmp
WizardImageStretch=no
WizardSmallImageFile=TeXmacs-small.bmp

;PrivilegesRequired=none

CloseApplications=yes

[Registry]
Root: HKCR; Subkey: ".tm"; ValueType: string; ValueName: ""; ValueData: "tmfile"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "tmfile"; ValueType: string; ValueName: ""; ValueData: "text/tm"; Flags: uninsdeletekey
Root: HKCR; Subkey: "tmfile\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\TeXmacs.ico"
Root: HKCR; Subkey: "tmfile\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\texmacs.exe"" ""%1""" 

[Files]
Source: ..\..\..\distr\TeXmacs-Windows\*; DestDir: {app}; Flags: recursesubdirs createallsubdirs ignoreversion
Source: TeXmacs.ico; DestDir: {app}

[Icons]
Name: "{group}\TeXmacs"; Filename: "{app}\bin\texmacs.exe"; IconFilename: "{app}\TeXmacs.ico"
Name: "{group}\Uninstall TeXmacs"; Filename: "{uninstallexe}"
Name: "{commondesktop}\TeXmacs"; Filename: "{app}\bin\texmacs.exe"; IconFilename: "{app}\TeXmacs.ico"

[UninstallDelete]
Type: files; Name: "{app}\*"
Type: dirifempty; Name: "{app}"

[Code]

procedure UninstallTeXmacs();
var
  FindRec: TFindRec;
  Uninstaller: String;
  FoundInstalled: Boolean;
  ConfirmedUninstall: Boolean;
  UninstallResultCode: integer;
begin
  Uninstaller := '';
  ConfirmedUninstall := false;
  FoundInstalled := FindFirst(ExpandConstant('{app}/unins*.exe'), FindRec);
  if FoundInstalled then
    if MsgBox('Before installing TeXmacs into the destination folder ('
              + ExpandConstant('{app}') + '), it is recommened to uninstall software already present in this folder.'
	      + #13#10 + 'Do you want to perform these uninstallations before installating?', mbConfirmation, MB_YESNO or MB_DEFBUTTON2) = idYes then
    ConfirmedUninstall := true;
  if ConfirmedUninstall then
  repeat
    Uninstaller := FindRec.Name;
    Exec(ExpandConstant('{app}/') + Uninstaller, '', '', SW_SHOW,
         ewWaitUntilTerminated, UninstallResultCode);
  until
    not FindNext(FindRec);
  FindClose(FindRec);
end;

procedure CurStepChanged(CurStep: TSetupStep);
begin
  if (CurStep = ssInstall) then
    UninstallTeXmacs();
end;
