<TeXmacs|1.99.2>

<style|beamer>

<\body>
  <screens|<\shown>
    \;

    <\with|par-mode|center>
      <\with|font-size|1.68|font-shape|long>
        <\with|color|red>
          The Truncated Fourier Transform

          <math|<with|color|black|\<wedge\>>>

          Applications
        </with>
      </with>

      <\with|color|blue>
        <math|\<diamondsuit\><space|-1.2spc>\<diamondsuit\><space|-1.2spc>\<diamondsuit\><space|-1.2spc>\<diamondsuit\><space|-1.2spc>\<diamondsuit\>>
      </with>

      <\name>
        <with|font-size|0.84|by><vspace|0.5fn>
      </name>

      <\with|font-size|1.19>
        <\with|font|chancery>
          Joris van der Hoeven<vspace|1fn>
        </with>
      </with>

      <\with|color|blue>
        <math|\<diamondsuit\><space|-1.2spc>\<diamondsuit\><space|-1.2spc>\<diamondsuit\><space|-1.2spc>\<diamondsuit\><space|-1.2spc>\<diamondsuit\>><vspace|1fn>
      </with>

      ISSAC 2004
    </with>

    \;

    <image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>
    <with|color|brown|<htab|5mm><with|font-size|0.84|A presentation using GNU
    <TeXmacs> (<verbatim|www.texmacs.org>)>><htab|5mm><image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>
  </shown>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Classical
    results>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|Fast multiplication in <math|\<bbb-C\>[X]>.>
    <|folded>
      <\itemize>
        <item>Cooley-Tuckey, Gauss.

        <item>Complexity: <math|O(n*log n)> operations in <math|\<bbb-C\>>.
      </itemize>
    </folded>

    <\folded>
      <with|color|#000080|Fast multiplication in <math|\<bbb-Z\>> and
      <math|\<cal-R\>[X]>.>
    <|folded>
      <\itemize>
        <item>Shnhage-Straen, Cantor-Kaltofen.

        <item><math|\<cal-R\>[x]/(x<rsup|n<rsup|2>>\<pm\>1)\<cong\>(\<cal-R\>[y]/(y<rsup|n>\<pm\>1))[x]/(x<rsup|n>-y)>

        <item>Complexity: <math|O(n*log n*log<rsup|2> n)> operations in
        <math|\<cal-R\>>.
      </itemize>
    </folded>

    <\folded>
      <with|color|#000080|Fast \S sparse \T multiplication in
      <math|\<cal-R\>[z<rsub|1>,\<ldots\>,z<rsub|d>]>.>
    <|folded>
      <\itemize>
        <item>Canny-Kaltofen-Lakshman.

        <item>Complexity: <math|O(s*log<rsup|2> s*log log s)>.

        <item>Formal power series: Lecerf-Schost, VdH.
      </itemize>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Classical
    drawbacks>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|Jumps in the complexity.>
    <|folded>
      <switch|<\shown>
        \;

        <\with|par-mode|center>
          <image|fft-jump-1.ps|0.7par|||>

          \;
        </with>
      </shown>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|fft-jump-2.ps|0.7par|||>

          \;
        </with>
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|fft-jump-3.ps|0.7par|||>

          \;
        </with>
      </hidden>>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Classical
    drawbacks>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|Unefficiency in higher dimensions.>
    <|folded>
      \;

      <\equation*>
        <tabular*|<tformat|<table|<row|<cell|<image|bidim.ps|0.25w|0.25h||>>>>>>\<times\><tabular*|<tformat|<table|<row|<cell|<image|bidim.ps|0.25w|0.25h||>>>>>>=<tabular*|<tformat|<table|<row|<cell|<image|bidim.ps|0.5w|0.5h||>>>>>>
      </equation*>

      <\itemize>
        <item>Let <math|P,Q\<in\>\<bbb-C\>[z<rsub|1>,\<ldots\>,z<rsub|d>]>
        with <math|deg P,deg Q\<less\>n>.

        <item>Input size: <math|s=O(<frac|n<rsup|d>|d!>)>.

        <item>Naive complexity: <math|O(d*n<rsup|d>*log n)\<gg\>O(s*log s)>.
      </itemize>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Notations>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|Notations.>
    <|folded>
      <\itemize>
        <item><math|\<cal-R\>\<ni\><frac|1|2>>: effective constant ring.

        <item><math|n=2<rsup|p>>.

        <item><math|\<omega\>\<in\>\<cal-R\>> primitive <math|n>-th root of
        unity.
      </itemize>
    </folded>

    <\folded>
      <with|color|#000080|Definition F.F.T.>
    <|folded>
      <\eqnarray*>
        <tformat|<table|<row|<cell|\<cal-R\><rsup|n>>|<cell|\<longrightarrow\>>|<cell|\<cal-R\><rsup|n>>>|<row|<cell|(a<rsub|0>,\<ldots\>,a<rsub|n-1>)>|<cell|\<longmapstolim\><rsup|FFT>>|<cell|(<wide|a|^><rsub|0>,\<ldots\>,<wide|a|^><rsub|n-1>)>>>>
      </eqnarray*>

      with

      <\equation*>
        <wide|a|^><rsub|i>=<big|sum><rsub|j=0><rsup|n-1>a<rsub|j>*\<omega\><rsup|i*j><big|.>=A(\<omega\><rsup|i>)
      </equation*>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|On-line
    computation>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    \;

    <switch|<\shown>
      \;

      <\with|par-mode|center>
        <image|fft-4.ps|0.6par|||>
      </with>

      \;
    </shown>|<\hidden>
      \;

      <\with|par-mode|center>
        <image|fft-4-b.ps|0.6par|||>
      </with>

      \;
    </hidden>>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|The
    cross relation>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|<math|[i]<rsub|p>>: bitwise mirror of <math|i> at
      length <math|p>>
    <|folded>
      <\itemize>
        <item><math|[3]<rsub|5>=[<wide|00011|\<bar\>>]<rsub|5>=[<wide|11000|\<bar\>>]<rsub|5>=24>

        <item><math|[26]<rsub|5>=[<wide|11010|\<bar\>>]<rsub|5>=[<wide|01011|\<bar\>>]<rsub|5>=11>
      </itemize>
    </folded>

    <\folded>
      <with|color|#000080|Cross relation>
    <|folded>
      <\equation*>
        <matrix|<tformat|<table|<row|<cell|x<rsub|s,i*m<rsub|s>+j>>>|<row|<cell|x<rsub|s,(i+1)*m<rsub|s>+j>>>>>>=<matrix|<tformat|<table|<row|<cell|1>|<cell|\<omega\><rsup|[i]<rsub|s>*m<rsub|s>>>>|<row|<cell|1>|<cell|\<um\>\<omega\><rsup|[i]<rsub|s>*m<rsub|s>>>>>>><matrix|<tformat|<table|<row|<cell|x<rsub|s-1,i*m<rsub|s>+j>>>|<row|<cell|x<rsub|s-1,(i+1)*m<rsub|s>+j>>>>>>.
      </equation*>
    </folded>

    <\folded>
      <with|color|#000080|Direct formulas>
    <|folded>
      <\eqnarray*>
        <tformat|<table|<row|<cell|x<rsub|s,i*m<rsub|s>+j>>|<cell|=>|<cell|(FFT<rsub|\<omega\><rsup|m<rsub|s>>>(a<rsub|j>,a<rsub|m<rsub|s>+j>,\<ldots\>,a<rsub|n-m<rsub|s>+j>))<rsub|[i]<rsub|s>>>>|<row|<cell|x<rsub|p,i>>|<cell|=>|<cell|<wide|a|^><rsub|[i]<rsub|p>>>>|<row|<cell|<wide|a|^><rsub|i>>|<cell|=>|<cell|x<rsub|p,[i]<rsub|p>>>>>>
      </eqnarray*>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|The
    Truncated Fourier Transform>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|Transformation at length
      <math|l\<leqslant\>n=2<rsup|p>>>
    <|folded>
      <\equation*>
        (a<rsub|0>,a<rsub|1>,\<ldots\>,a<rsub|l-1>)\<longleftrightarrow\>(<wide|a|^><rsub|[0]<rsub|p>>,<wide|a|^><rsub|[1]<rsub|p>>,\<ldots\>,<wide|a|^><rsub|[l-1]<rsub|p>>)
      </equation*>
    </folded>

    <\folded>
      <with|color|#000080|Computation>
    <|folded>
      <switch|<\shown>
        \;

        <\with|par-mode|center>
          <image|fullfft.ps|0.75w|0.75h||>
        </with>

        \;
      </shown>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|truncfft.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>>
    </folded>

    <\folded>
      <with|color|#000080|Complexity>
    <|folded>
      <\theorem*>
        The <abbr|T.F.T.> of <math|(a<rsub|0>,\<ldots\>,a<rsub|l-1>)>
        <abbr|w.r.t.> <math|\<omega\>> can be computed using <math|l*p+n>
        additions-subtractions and <math|\<lceil\>(l*p+n)/2\<rceil\>>
        multiplications with powers of <math|\<omega\>>.
      </theorem*>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Inverse
    transformation>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|Observation on the cross relation>
    <|folded>
      <\equation*>
        <matrix|<tformat|<table|<row|<cell|x<rsub|0>>>|<row|<cell|y<rsub|0>>>>>>=<matrix|<tformat|<table|<row|<cell|1>|<cell|\<omega\><rsup|i>>>|<row|<cell|1>|<cell|-\<omega\><rsup|i>>>>>>*<matrix|<tformat|<table|<row|<cell|x<rsub|1>>>|<row|<cell|y<rsub|1>>>>>>
      </equation*>

      <\with|par-mode|center>
        <block*|<tformat|<cwith|1|1|1|1|cell-background|pastel
        blue>|<table|<row|<cell|<math|\<forall\>\<epsilon\>,\<delta\>\<in\>{0,1}>:
        <math|(x<rsub|\<epsilon\>>,y<rsub|\<delta\>>)> determines
        <math|(x<rsub|1-\<epsilon\>>,y<rsub|1-\<delta\>>)>>>>>>
      </with>

      <\itemize>
        <item><math|x<rsub|0>=x<rsub|1>+\<omega\><rsup|i>*y<rsub|1>> et
        <math|y<rsub|0>=x<rsub|1>-\<omega\><rsup|i>*y<rsub|1>>

        <item><math|x<rsub|1>=<frac|1|2>*(x<rsub|0>+y<rsub|0>)> et
        <math|y<rsub|1>=<frac|1|2>*\<omega\><rsup|\<um\>i>*(x<rsub|0>-y<rsub|0>)>

        <item><math|x<rsub|0>=2*x<rsub|1>-y<rsub|0>> et
        <math|y<rsub|1>=\<omega\><rsup|\<um\>i>*(x<rsub|1>-y<rsub|0>)>

        <item><math|x<rsub|1>=x<rsub|0>-\<omega\><rsup|i>*y<rsub|1>> et
        <math|y<rsub|0>=x<rsub|0>-2*\<omega\><rsup|i>*y<rsub|1>>
      </itemize>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Inverse
    transformation>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|The inverse <abbr|T.F.T.>>
    <|folded>
      <switch|<\shown>
        \;

        <\with|par-mode|center>
          <image|tfft1.ps|0.75w|0.75h||>
        </with>

        \;
      </shown>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft2.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft3.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft4.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft4b.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft4c.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft4d.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft5.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft6.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|tfft7.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>>
    </folded>

    <\folded>
      <with|color|#000080|Complexity>
    <|folded>
      <\theorem*>
        One may recover <math|(a<rsub|0>,\<ldots\>,a<rsub|l-1>)> from its
        <abbr|T.F.T.> <abbr|w.r.t.> <math|\<omega\>> using <math|l*p+n>
        additions-subtractions, <math|\<lceil\>(l*p+n)/2\<rceil\>>
        multiplications with powers of <math|\<omega\>> and <math|2*n>
        shifts.
      </theorem*>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Remarks>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|Compatibility with Schnhage-Strassen>
    <|folded>
      <\itemize>
        <item>All multiplications are by powers of <math|\<omega\>>.
      </itemize>
    </folded>

    <\folded>
      <with|color|#000080|Generalization to the case
      <math|<frac|1|2>\<nin\>\<cal-R\>>>
    <|folded>
      For <math|j> with <math|j<rsup|3>=1>, study:

      <switch|<\shown>
        <\equation*>
          <matrix|<tformat|<table|<row|<cell|a<rsub|1>>>|<row|<cell|b<rsub|1>>>|<row|<cell|c<rsub|1>>>>>>=<matrix|<tformat|<table|<row|<cell|1>|<cell|1>|<cell|1>>|<row|<cell|1>|<cell|j>|<cell|j<rsup|2>>>|<row|<cell|1>|<cell|j<rsup|2>>|<cell|j>>>>>*<matrix|<tformat|<table|<row|<cell|a<rsub|0>>>|<row|<cell|b<rsub|0>>>|<row|<cell|c<rsub|0>>>>>>
        </equation*>
      </shown>|<\hidden>
        <\equation*>
          <matrix|<tformat|<table|<row|<cell|a<rsub|1>>>|<row|<cell|b<rsub|1>>>|<row|<cell|c<rsub|1>>>>>>=<matrix|<tformat|<table|<row|<cell|1>|<cell|1>|<cell|1>>|<row|<cell|1>|<cell|j>|<cell|j<rsup|2>>>|<row|<cell|1>|<cell|j<rsup|2>>|<cell|j>>>>><matrix|<tformat|<table|<row|<cell|1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|\<omega\><rsup|i>>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|\<omega\><rsup|2*i>>>>>>*<matrix|<tformat|<table|<row|<cell|a<rsub|0>>>|<row|<cell|b<rsub|0>>>|<row|<cell|c<rsub|0>>>>>>
        </equation*>
      </hidden>>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Remarks>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <with|color|#000080|T.F.T. with respect to subsets
      <math|{0,\<ldots\>,n-1}>>
    <|folded>
      <switch|<\shown>
        \;

        <\with|par-mode|center>
          <image|fullfft.ps|0.75w|0.75h||>
        </with>

        \;
      </shown>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|truncfft.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|segfft.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>|<\hidden>
        \;

        <\with|par-mode|center>
          <image|multifft.ps|0.75w|0.75h||>
        </with>

        \;
      </hidden>>
    </folded>

    <\folded>
      <with|color|#000080|Theoretical note for
      <math|n\<rightarrow\>\<infty\>>>
    <|folded>
      <\itemize>
        <item>Sequence <math|\<omega\><rsub|1>=1,\<omega\><rsub|2>,\<omega\><rsub|4>,\<ldots\>\<in\>\<bbb-C\>>
        with <math|\<omega\><rsub|2*p><rsup|2>=\<omega\><rsub|p>>
        <math|<with|color|red|\<rightsquigarrow\>>>
        <math|\<omega\>=\<omega\><rsub|2<rsup|\<infty\>>>>

        <item><math|\<omega\><rsup|[i]>\<assign\>\<omega\><rsub|2<rsup|p>><rsup|[i]<rsub|p>>>
        for all <math|p> with <math|i\<less\>2<rsup|p>>.

        <item>L.F.T. of <math|a<rsub|0>,a<rsub|1>,a<rsub|2>,\<ldots\>> with
        <math|\<rho\>(<big|sum><rsub|i><big|.>a<rsub|i>*z<rsup|i>)\<gtr\>1> :

        <\equation*>
          a(\<omega\><rsup|[0]>),a(\<omega\><rsup|[1]>),a(\<omega\><rsup|[2]>),\<ldots\>
        </equation*>
      </itemize>
    </folded>
  </hidden>|<\hidden>
    <with|font-series|bold|font-size|1.19|color|dark
    grey|<block*|<tformat|<cwith|1|-1|1|-1|cell-background|broken
    white>|<twith|table-width|1par>|<cwith|1|1|2|2|cell-hyphen|t>|<cwith|1|1|2|2|cell-bsep|1spc>|<cwith|1|1|2|2|cell-tsep|1spc>|<cwith|1|-1|1|-1|cell-lborder|0.5ln>|<cwith|1|-1|1|-1|cell-rborder|0.5ln>|<cwith|1|-1|1|-1|cell-bborder|0.5ln>|<cwith|1|-1|1|-1|cell-tborder|0.5ln>|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|1|1|cell-rborder|0ln>|<cwith|1|1|2|2|cell-lborder|0ln>|<cwith|1|1|2|2|cell-rborder|0ln>|<cwith|1|1|3|3|cell-lborder|0ln>|<cwith|1|1|1|1|cell-valign|c>|<cwith|1|1|3|3|cell-valign|c>|<cwith|1|1|2|2|cell-valign|c>|<cwith|1|1|1|1|cell-vcorrect|n>|<cwith|1|1|3|3|cell-vcorrect|n>|<table|<row|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu1.png|0.2w|0.2h||>>|<cell|<with|font-size|1|<with|color|black|Multivariate
    case>>>|<cell|<image|$TEXMACS_PATH/misc/images/tm_gnu2.png|0.2w|0.2h||>>>>>>>

    <\folded>
      <math|<assign|fij|<macro|i|j|f<space|-0.2spc>(\<omega\><rsup|<arg|i>><space|-0.4spc>,<space|-0.4spc>\<omega\><rsup|<arg|j>>)>>><with|color|#000080|<abbr|T.F.T.>
      of <math|(f<rsub|i<rsub|1>,\<ldots\>,i<rsub|d>>)<rsub|(i<rsub|1>,\<ldots\>i<rsub|d>)\<in\>\<cal-S\>>>
      with finite <math|\<cal-S\>\<subseteq\>\<bbb-N\><rsup|d>>>
    <|folded>
      <switch|<\shown>
        <\equation*>
          <with|font-size|0.59|<tabular*|<tformat|<cwith|3|3|1|1|cell-lborder|1ln>|<cwith|3|3|1|1|cell-rborder|1ln>|<cwith|3|3|1|1|cell-bborder|1ln>|<cwith|3|3|1|1|cell-tborder|1ln>|<cwith|4|4|1|1|cell-lborder|1ln>|<cwith|4|4|1|1|cell-rborder|1ln>|<cwith|4|4|1|1|cell-bborder|1ln>|<cwith|4|4|1|1|cell-tborder|1ln>|<cwith|5|5|1|1|cell-lborder|1ln>|<cwith|5|5|1|1|cell-rborder|1ln>|<cwith|5|5|1|1|cell-bborder|1ln>|<cwith|5|5|1|1|cell-tborder|1ln>|<cwith|1|1|1|1|cell-lborder|1ln>|<cwith|1|1|1|1|cell-rborder|1ln>|<cwith|1|1|1|1|cell-bborder|1ln>|<cwith|1|1|1|1|cell-tborder|1ln>|<cwith|2|2|1|1|cell-lborder|1ln>|<cwith|2|2|1|1|cell-rborder|1ln>|<cwith|2|2|1|1|cell-bborder|1ln>|<cwith|2|2|1|1|cell-tborder|1ln>|<cwith|2|2|2|2|cell-lborder|1ln>|<cwith|2|2|2|2|cell-rborder|1ln>|<cwith|2|2|2|2|cell-bborder|1ln>|<cwith|2|2|2|2|cell-tborder|1ln>|<cwith|3|3|2|2|cell-lborder|1ln>|<cwith|3|3|2|2|cell-rborder|1ln>|<cwith|3|3|2|2|cell-bborder|1ln>|<cwith|3|3|2|2|cell-tborder|1ln>|<cwith|4|4|2|2|cell-lborder|1ln>|<cwith|4|4|2|2|cell-rborder|1ln>|<cwith|4|4|2|2|cell-bborder|1ln>|<cwith|4|4|2|2|cell-tborder|1ln>|<cwith|5|5|2|2|cell-lborder|1ln>|<cwith|5|5|2|2|cell-rborder|1ln>|<cwith|5|5|2|2|cell-bborder|1ln>|<cwith|5|5|2|2|cell-tborder|1ln>|<cwith|3|3|3|3|cell-lborder|1ln>|<cwith|3|3|3|3|cell-rborder|1ln>|<cwith|3|3|3|3|cell-bborder|1ln>|<cwith|3|3|3|3|cell-tborder|1ln>|<cwith|4|4|3|3|cell-lborder|1ln>|<cwith|4|4|3|3|cell-rborder|1ln>|<cwith|4|4|3|3|cell-bborder|1ln>|<cwith|4|4|3|3|cell-tborder|1ln>|<cwith|5|5|3|3|cell-lborder|1ln>|<cwith|5|5|3|3|cell-rborder|1ln>|<cwith|5|5|3|3|cell-bborder|1ln>|<cwith|5|5|3|3|cell-tborder|1ln>|<cwith|4|4|4|4|cell-lborder|1ln>|<cwith|4|4|4|4|cell-rborder|1ln>|<cwith|4|4|4|4|cell-bborder|1ln>|<cwith|4|4|4|4|cell-tborder|1ln>|<cwith|5|5|4|4|cell-lborder|1ln>|<cwith|5|5|4|4|cell-rborder|1ln>|<cwith|5|5|4|4|cell-bborder|1ln>|<cwith|5|5|4|4|cell-tborder|1ln>|<cwith|5|5|5|5|cell-lborder|1ln>|<cwith|5|5|5|5|cell-rborder|1ln>|<cwith|5|5|5|5|cell-bborder|1ln>|<cwith|5|5|5|5|cell-tborder|1ln>|<cwith|6|6|1|-1|cell-lborder|1ln>|<cwith|6|6|1|-1|cell-rborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-tborder|1ln>|<cwith|1|-1|1|-1|cell-width|14mm>|<cwith|1|-1|1|-1|cell-height|13.5mm>|<table|<row|<cell|f<rsub|0,5>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|f<rsub|0,4>>|<cell|f<rsub|1,4>>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|f<rsub|0,3>>|<cell|f<rsub|1,3>>|<cell|f<rsub|2,3>>|<cell|>|<cell|>|<cell|>>|<row|<cell|f<rsub|0,2>>|<cell|f<rsub|1,2>>|<cell|f<rsub|2,2>>|<cell|f<rsub|3,2>>|<cell|>|<cell|>>|<row|<cell|f<rsub|0,1>>|<cell|f<rsub|1,1>>|<cell|f<rsub|2,1>>|<cell|f<rsub|3,1>>|<cell|f<rsub|4,1>>|<cell|>>|<row|<cell|f<rsub|0,0>>|<cell|f<rsub|1,0>>|<cell|f<rsub|2,0>>|<cell|f<rsub|3,0>>|<cell|f<rsub|4,0>>|<cell|f<rsub|5,0>>>>>>>
        </equation*>
      </shown>|<\hidden>
        <\equation*>
          <with|font-size|0.59|<tabular*|<tformat|<cwith|3|3|1|1|cell-lborder|1ln>|<cwith|3|3|1|1|cell-rborder|1ln>|<cwith|3|3|1|1|cell-bborder|1ln>|<cwith|3|3|1|1|cell-tborder|1ln>|<cwith|4|4|1|1|cell-lborder|1ln>|<cwith|4|4|1|1|cell-rborder|1ln>|<cwith|4|4|1|1|cell-bborder|1ln>|<cwith|4|4|1|1|cell-tborder|1ln>|<cwith|5|5|1|1|cell-lborder|1ln>|<cwith|5|5|1|1|cell-rborder|1ln>|<cwith|5|5|1|1|cell-bborder|1ln>|<cwith|5|5|1|1|cell-tborder|1ln>|<cwith|1|1|1|1|cell-lborder|1ln>|<cwith|1|1|1|1|cell-rborder|1ln>|<cwith|1|1|1|1|cell-bborder|1ln>|<cwith|1|1|1|1|cell-tborder|1ln>|<cwith|2|2|1|1|cell-lborder|1ln>|<cwith|2|2|1|1|cell-rborder|1ln>|<cwith|2|2|1|1|cell-bborder|1ln>|<cwith|2|2|1|1|cell-tborder|1ln>|<cwith|2|2|2|2|cell-lborder|1ln>|<cwith|2|2|2|2|cell-rborder|1ln>|<cwith|2|2|2|2|cell-bborder|1ln>|<cwith|2|2|2|2|cell-tborder|1ln>|<cwith|3|3|2|2|cell-lborder|1ln>|<cwith|3|3|2|2|cell-rborder|1ln>|<cwith|3|3|2|2|cell-bborder|1ln>|<cwith|3|3|2|2|cell-tborder|1ln>|<cwith|4|4|2|2|cell-lborder|1ln>|<cwith|4|4|2|2|cell-rborder|1ln>|<cwith|4|4|2|2|cell-bborder|1ln>|<cwith|4|4|2|2|cell-tborder|1ln>|<cwith|5|5|2|2|cell-lborder|1ln>|<cwith|5|5|2|2|cell-rborder|1ln>|<cwith|5|5|2|2|cell-bborder|1ln>|<cwith|5|5|2|2|cell-tborder|1ln>|<cwith|3|3|3|3|cell-lborder|1ln>|<cwith|3|3|3|3|cell-rborder|1ln>|<cwith|3|3|3|3|cell-bborder|1ln>|<cwith|3|3|3|3|cell-tborder|1ln>|<cwith|4|4|3|3|cell-lborder|1ln>|<cwith|4|4|3|3|cell-rborder|1ln>|<cwith|4|4|3|3|cell-bborder|1ln>|<cwith|4|4|3|3|cell-tborder|1ln>|<cwith|5|5|3|3|cell-lborder|1ln>|<cwith|5|5|3|3|cell-rborder|1ln>|<cwith|5|5|3|3|cell-bborder|1ln>|<cwith|5|5|3|3|cell-tborder|1ln>|<cwith|4|4|4|4|cell-lborder|1ln>|<cwith|4|4|4|4|cell-rborder|1ln>|<cwith|4|4|4|4|cell-bborder|1ln>|<cwith|4|4|4|4|cell-tborder|1ln>|<cwith|5|5|4|4|cell-lborder|1ln>|<cwith|5|5|4|4|cell-rborder|1ln>|<cwith|5|5|4|4|cell-bborder|1ln>|<cwith|5|5|4|4|cell-tborder|1ln>|<cwith|5|5|5|5|cell-lborder|1ln>|<cwith|5|5|5|5|cell-rborder|1ln>|<cwith|5|5|5|5|cell-bborder|1ln>|<cwith|5|5|5|5|cell-tborder|1ln>|<cwith|6|6|1|-1|cell-lborder|1ln>|<cwith|6|6|1|-1|cell-rborder|1ln>|<cwith|6|6|1|-1|cell-bborder|1ln>|<cwith|6|6|1|-1|cell-tborder|1ln>|<cwith|1|-1|1|-1|cell-width|14mm>|<cwith|1|-1|1|-1|cell-height|13.5mm>|<table|<row|<cell|f(1,\<omega\><rsup|3>)>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|f(1,\<omega\><rsup|5>)>|<cell|<fij|4|5>>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|f(1,\<omega\><rsup|6>)>|<cell|<fij|4|6>>|<cell|<fij|2|6>>|<cell|>|<cell|>|<cell|>>|<row|<cell|f(1,\<omega\><rsup|2>)>|<cell|<fij|4|2>>|<cell|<fij|2|2>>|<cell|<fij|6|2>>|<cell|>|<cell|>>|<row|<cell|f(1,\<omega\><rsup|4>)>|<cell|<fij|4|4>>|<cell|<fij|2|4>>|<cell|<fij|6|4>>|<cell|<fij|5|4>>|<cell|>>|<row|<cell|f(1,1)>|<cell|f(\<omega\><rsup|4>,1)>|<cell|f(\<omega\><rsup|2>,1)>|<cell|f(\<omega\><rsup|6>,1)>|<cell|f(\<omega\><rsup|5>,1)>|<cell|f(\<omega\><rsup|3>,1)>>>>>>
        </equation*>
      </hidden>>
    </folded>

    <\folded>
      <with|color|#000080|Complexity if <math|\<cal-S\>={(i<rsub|1>,\<ldots\>,i<rsub|d>)\<in\>\<bbb-N\><rsup|d>:i<rsub|1>+\<cdots\>+i<rsub|d>\<less\>n}>>
    <|folded>
      <\theorem*>
        Assume that <math|\<cal-R\>> admits \S sufficiently many \T primitive
        <math|2<rsup|p>>-th roots of unity. Let
        <math|f,g\<in\>\<cal-R\>[z<rsub|1>,\<ldots\>,z<rsub|d>]> be
        polynomials with <math|deg <no-break>f+deg g\<less\>r> and
        <math|s=<binom|r+d-1|r>>. Then the product <math|f*g> can be computed
        using <math|O(s*log s)> operations in <math|\<cal-R\>>.
      </theorem*>
    </folded>

    <\folded>
      <with|color|#000080|Complexity in general>
    <|folded>
      <\equation*>
        O(\|\<cal-S\>\|*log \|\<cal-S\>\|+\|\<delta\>
        \<cal-S\>\|*\|\<partial\> \<cal-S\>\|)
      </equation*>
    </folded>

    <\folded>
      <with|color|#000080|Formal power series>
    <|folded>
      <\itemize>
        <item>Additional <math|O(log s)> overhead.
      </itemize>
    </folded>
  </hidden>>
</body>

<\references>
  <\collection>
    <associate|auto-1|<tuple|1|?>>
    <associate|auto-2|<tuple|2|?>>
    <associate|auto-3|<tuple|3|?>>
    <associate|cross-rel|<tuple|1|?>>
    <associate|eq-fonc|<tuple|1|15>>
    <associate|mv-th|<tuple|<with|mode|<quote|math>|\<bullet\>>|?>>
    <associate|toc-1|<tuple|<uninit>|2>>
    <associate|toc-10|<tuple|2|5>>
    <associate|toc-11|<tuple|2|5>>
    <associate|toc-12|<tuple|2|5>>
    <associate|toc-13|<tuple|2|5>>
    <associate|toc-14|<tuple|2|6>>
    <associate|toc-15|<tuple|2|6>>
    <associate|toc-16|<tuple|2|6>>
    <associate|toc-17|<tuple|2|7>>
    <associate|toc-18|<tuple|2|7>>
    <associate|toc-19|<tuple|2|7>>
    <associate|toc-2|<tuple|<uninit>|3>>
    <associate|toc-20|<tuple|2|7>>
    <associate|toc-21|<tuple|2|8>>
    <associate|toc-22|<tuple|2|8>>
    <associate|toc-23|<tuple|2|8>>
    <associate|toc-24|<tuple|2|8>>
    <associate|toc-25|<tuple|2|8>>
    <associate|toc-26|<tuple|2|8>>
    <associate|toc-27|<tuple|2|9>>
    <associate|toc-28|<tuple|2|9>>
    <associate|toc-29|<tuple|2|9>>
    <associate|toc-3|<tuple|<uninit>|3>>
    <associate|toc-30|<tuple|2|10>>
    <associate|toc-31|<tuple|2|10>>
    <associate|toc-32|<tuple|2|10>>
    <associate|toc-33|<tuple|2|11>>
    <associate|toc-34|<tuple|2|12>>
    <associate|toc-35|<tuple|2|13>>
    <associate|toc-36|<tuple|2|14>>
    <associate|toc-37|<tuple|2|14>>
    <associate|toc-38|<tuple|2|14>>
    <associate|toc-39|<tuple|2|15>>
    <associate|toc-4|<tuple|<uninit>|3>>
    <associate|toc-40|<tuple|2|15>>
    <associate|toc-41|<tuple|2|15>>
    <associate|toc-42|<tuple|2|15>>
    <associate|toc-43|<tuple|2|16>>
    <associate|toc-44|<tuple|2|16>>
    <associate|toc-45|<tuple|2|16>>
    <associate|toc-46|<tuple|2|17>>
    <associate|toc-47|<tuple|2|17>>
    <associate|toc-48|<tuple|2|17>>
    <associate|toc-49|<tuple|2|17>>
    <associate|toc-5|<tuple|<uninit>|3>>
    <associate|toc-50|<tuple|2|?>>
    <associate|toc-6|<tuple|<uninit>|4>>
    <associate|toc-7|<tuple|<uninit>|4>>
    <associate|toc-8|<tuple|2|4>>
    <associate|toc-9|<tuple|2|4>>
  </collection>
</references>