<TeXmacs|1.0.7.20>

<style|<tuple|beamer|maxima|pari|mathemagix>>

<\body>
  <screens|<\shown>
    \;

    <\with|par-mode|center>
      <strong|<with|font-base-size|17|Effective real numbers in
      <name|Mmxlib>>>

      by Joris van der Hoeven
    </with>

    <\with|par-mode|center>
      <tabular*|<tformat|<cwith|1|1|2|2|cell-valign|c>|<table|<row|<cell|
      >|<cell|>|<cell|>>|<row|<cell|>|<cell|>|<cell|>>|<row|<cell|>|<cell|<image|texmacs-chip.ps|0.5w|0.5h||>>|<cell|>>|<row|<cell|>|<cell|>|<cell|>>|<row|<cell|>|<cell|Presentation
      with <strong|<with|color|dark green|GNU> <TeXmacs*>>
      (<verbatim|www.texmacs.org)>>|<cell|>>>>>
    </with>

    \;
  </shown>|<\hidden>
    <tit|Effective real numbers in <name|Mmxlib>>

    <\with|par-mode|center>
      <verbatim|http://www.mathemagix.org/mmxweb/web/welcome-mml.en.html>
    </with>

    <\session|mathemagix|default>
      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        x:Real\<longequal\>sin sin real 2;
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        x
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        approximate(x,1.0e\<um\>35);
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        M:Matrix Real\<longequal\><matrix|<tformat|<table|<row|<cell|x>|<cell|x+2>>|<row|<cell|2-x<rsup|2>>|<cell|cos
        x>>>>>;
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        M;
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        M<rsup|20>;
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        exp (x+exp(\<um\>real 100))-exp (x);
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        exp (x+exp(\<um\>real 1000))-exp (x);
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        \;
      </input-math>
    </session>
  </hidden>|<\hidden>
    <tit|Effective analytic functions in <name|Mmxlib>>

    <\session|mathemagix|default>
      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        z:Analytic\<longequal\>analytic (0,1);
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        exp(z);
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        exp(z)[int 20];
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        \<ell\>:Analytic\<longequal\>log(1-z);
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        radius(\<ell\>);
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        evaluate(\<ell\>,complex(1/2));
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        continuate(\<ell\>,complex(1/2));
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        continuate(\<ell\>,turn(complex(1)));
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        \;
      </input-math>
    </session>
  </hidden>|<\hidden>
    <tit|Solving differential equations>

    <\equation*>
      f<rprime|''>=(z<rsup|2>+1)*f<rprime|'>+\<mathe\><rsup|z>*f;<space|2em>f(0)=1,f<rprime|'>(0)=1+2*\<mathi\>.
    </equation*>

    <\session|mathemagix|default>
      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        f:Analytic\<longequal\>solve_lde((z<rsup|2>+1,exp(z)),(complex(1),complex(1,2)));
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        f;
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        u:Complex\<longequal\>evaluate(f,complex(1/10));
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        u;
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        approximate(u,1.0e\<um\>81);
      </input-math>

      <\input-math|<with|color|red|Mmx <math|\<gg\>>> >
        \;
      </input-math>
    </session>
  </hidden>|<\hidden>
    <tit|Definition of effective real numbers>

    <\itemize>
      <unroll|<\shown>
        <item><math|<wide|x|~>\<in\>\<bbb-D\>=\<bbb-Z\>*2<rsup|\<bbb-Z\>>> is
        an <math|\<varepsilon\>>-approximation of <math|x\<in\>\<bbb-R\>> if
        <math|\|<wide|x|~>-x\|\<less\>\<varepsilon\>>.
      </shown>|<\hidden*>
        <item><em|Approximation algorithm> for <math|x>: computes
        <math|\<varepsilon\>> <math|\<longmapsto\>>
        <math|\<varepsilon\>>-approximation of <math|x>.
      </hidden*>|<\hidden*>
        <item><em|Effective real number>: <math|x\<in\>\<bbb-R\>> which
        admits an approximation algorithm.
      </hidden*>|<\hidden*>
        <item><em|Complexity> of <math|x>: time needed to compute a
        <math|2<rsup|\<um\>l>>-approximation.
      </hidden*>|<\hidden*>
        <item>No zero-test for effective real numbers.
      </hidden*>|<\hidden*>
        <item>References: Bishop and Bridges, Blanck, Mller, vdH,
        <abbr|etc.>
      </hidden*>>
    </itemize>

    \;
  </hidden>|<\hidden>
    <tit|Implementation by layers>

    <\description-long>
      <unroll|<\shown>
        <item*|Fast arithmetic>Fast computations on mantissas (Karatsuba,
        FFT, Brent, Chudnovsky<rsup|2>, VdH, etc.).

        Implementations: <name|Gmp>, <name|Cln>, ...
      </shown>|<\hidden*>
        <item*|Low-level validated arithmetic>Correct rounding or
        well-specified bounds on the error.

        Implementations: <name|Mpfr>, ...
      </hidden*>|<\hidden*>
        <item*|High-level validated arithmetic>Template types for intervals,
        balls, Lipschitz balls, etc.

        Implementations: <name|Mpfi>, <name|Irram>, <name|Mmxlib>, ...
      </hidden*>|<\hidden*>
        <item*|High-level interface>Given a required precision for the
        result, automatically find precisions for all intermediate
        computations.

        Implementations: <name|Irram>, <name|Mmxlib>, ...
      </hidden*>>
    </description-long>
  </hidden>|<\hidden>
    <tit|Modeling effective real numbers>

    <\itemize>
      <unroll|<\shown>
        <item>Example: addition

        <\code>
          class add_real_rep: public real_rep {

          \ \ real x, y;

          \ \ add_real_rep (const real& x2, const real& y2):

          \ \ \ \ x (x2), y (y2) {}

          \ \ dyadic approximate (const dyadic& eps) {

          \ \ \ \ return x-\<gtr\>approximate (eps/2) + y-\<gtr\>approximate
          (eps/2); }

          };
        </code>
      </shown>|<\hidden*>
        <item>Model sets of effective real numbers by acyclic graphs:

        <\with|par-mode|center>
          <with|gr-mode|<tuple|edit|spline>|gr-frame|<tuple|scale|1cm|<tuple|0.500003gw|0.500002gh>>|gr-geometry|<tuple|geometry|0.303832par|0.192759par|center>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|10|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-text-at-halign|center|<graphics|<with|text-at-halign|center|<text-at|<math|+>|<point|0|1.5>>>|<with|text-at-halign|center|<text-at|<math|\<times\>>|<point|-1|0.5>>>|<line|<point|-0.176793|1.41672>|<point|-0.80333|0.790184>>|<with|text-at-halign|center|<text-at|<math|\<um\>>|<point|0.7|0.5>>>|<with|text-at-halign|center|<text-at|1|<point|-1.8|-1.5>>>|<with|text-at-halign|center|<text-at|3|<point|-0.3|-1.5>>>|<line|<point|0.144943|1.39979>|<point|0.686814|0.790184>>|<line|<point|-0.80333|0.383781>|<point|-0.3|-0.1>>|<line|<point|-1.20973|0.383781>|<point|-1.7008|-0.0903559>>|<with|text-at-halign|center|<text-at|sin|<point|-1.8|-0.4>>>|<with|text-at-halign|center|<text-at|cos|<point|-0.3|-0.4>>>|<line|<point|-1.8024|-0.564493>|<point|-1.8|-1.1>>|<spline|<point|0.602146|0.383781>|<point|0.4|0>|<point|0.0433424|-0.276624>>|<spline|<point|0.906949|0.400714>|<point|0.6|-0.6>|<point|-0.109059|-1.19103>>|<line|<point|-0.301065|-0.564493>|<point|-0.301065|-1.1233>>|<with|text-at-halign|center|<text-at|<math|cos>|<point|-2.2|1.5>>>|<spline|<point|-2.23148|1.39479>|<point|-2.2|0.6>|<point|-2.01134|-0.112283>>>>
        </with>
      </hidden*>|<\hidden*>
        <item>Computations in memory <math|\<rightarrow\>> don't use
        classical numerical algorithms.
      </hidden*>>
    </itemize>

    \;
  </hidden>|<\hidden>
    <tit|<em|A priori> error estimates>

    <\itemize>
      <unroll|<\shown>
        <item>Distribute tolerance <math|\<varepsilon\>> <em|a priori> over
        nodes of <math|n>-ary operations (<math|n\<gtr\>1>).
      </shown>|<\hidden*>
        <switch|<\shown>
          <item>Can be bad in case of badly nested expressions:

          <\equation*>
            <tree|+|x<rsub|1>|<tree|+|\<ddots\>|<tree|+|x<rsub|r-1>|x<rsub|r>>>><space|6em><tree|\<varepsilon\>|<with|math-display|false|<frac|1|2>>*\<varepsilon\>|<tree|<with|math-display|false|<frac|1|2>>*\<varepsilon\>|\<ddots\>|<tree|\<vdots\>|<with|math-display|false|<frac|1|2<rsup|r-1>>>*\<varepsilon\>|<with|math-display|false|<frac|1|2<rsup|r-1>>>*\<varepsilon\>>>>
          </equation*>
        </shown>|<\hidden>
          <item>Balanced error estimates: redistribute as a function of
          <em|weight>:

          <\equation*>
            <tree|+|x<rsub|1>|<tree|+|\<ddots\>|<tree|+|x<rsub|r-1>|x<rsub|r>>>><space|6em><tree|\<varepsilon\>|<with|math-display|false|<frac|1|r>>*\<varepsilon\>|<tree|<with|math-display|false|<frac|r-1|r>>*\<varepsilon\>|\<ddots\>|<tree|\<vdots\>|<with|math-display|false|<frac|1|r>>*\<varepsilon\>|<with|math-display|false|<frac|1|r>>*\<varepsilon\>>>>
          </equation*>
        </hidden>>
      </hidden*>|<\hidden*>
        <item>Possible loss of <math|log w> bits of precision; still
        unacceptable.
      </hidden*>>
    </itemize>

    \;
  </hidden>|<\hidden>
    <tit|<em|A posteriori> error estimates>

    <\itemize>
      <unroll|<\shown>
        <item>Perform whole computation using interval arithmetic.

        While result not precise enough:

        \ \ \ \ Double precision and redo entire computation.
      </shown>|<\hidden*>
        <item>First improvement:

        For each instance of <verbatim|real_rep>, keep best current
        approximation in memory.
      </hidden*>|<\hidden*>
        <item>Second improvement:

        Don't double precision, but estimated computation time.
      </hidden*>>
    </itemize>

    \;
  </hidden>|<\hidden>
    <tit|Model for complexity analysis>

    <with|color|red|Global approximation problem>

    <unroll|<\shown>
      <with|color|blue|Input>: an acyclic graph <math|G> with for each node
      <math|\<alpha\>\<in\>G>:

      <\itemize>
        <item>A real function <math|f<rsub|\<alpha\>>> from the library.

        Induces by induction a real number
        <math|x<rsub|\<alpha\>>=f<rsub|\<alpha\>>(x<rsub|\<alpha\>[1]>,\<ldots\>,x<rsub|\<alpha\>[\|\<alpha\>\|]>)>.

        <item>A tolerance <math|\<varepsilon\><rsub|\<alpha\>>\<in\>\<bbb-D\><rsup|\<gtr\>>>.
      </itemize>
    </shown>|<\hidden*>
      <with|color|blue|Output>: for each node an interval
      <math|\<b-x\><rsub|\<alpha\>>\<ni\>x<rsub|\<alpha\>>> with

      <\itemize>
        <item><math|r<rsub|\<b-x\><rsub|\<alpha\>>>\<less\>\<varepsilon\><rsub|\<alpha\>>>.

        <item><math|\<b-x\><rsub|\<alpha\>>\<supseteq\>f<rsub|\<alpha\>>(\<b-x\><rsub|\<alpha\>[1]>,\<ldots\>,\<b-x\><rsub|\<alpha\>[\|\<alpha\>\|]>)>.
      </itemize>
    </hidden*>|<\hidden*>
      <with|color|blue|Drawbacks>

      <\itemize>
        <item>Does not model incremental computations.

        <item>No dependency of computations on intermediate results.
      </itemize>
    </hidden*>>
  </hidden>|<\hidden>
    <tit|Example>

    <switch|<\shown>
      \;

      <\with|par-mode|center>
        <with|gr-mode|<tuple|edit|text-at>|gr-frame|<tuple|scale|1cm|<tuple|0.6gw|0.299996gh>>|gr-geometry|<tuple|geometry|0.481472par|0.398042par|center>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|10|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-text-at-halign|center|gr-color|red|<graphics|<with|text-at-halign|center|<text-at|sin|<point|-3|3>>>|<with|text-at-halign|center|<text-at|<math|+>|<point|-1|3>>>|<with|text-at-halign|center|<text-at|<math|\<times\>>|<point|0|1>>>|<with|text-at-halign|center|<text-at|2|<point|-1|-1>>>|<with|text-at-halign|center|<text-at|<math|3>|<point|1|-1>>>|<with|text-at-halign|center|<text-at|cos|<point|-3|1>>>|<with|text-at-halign|center|<text-at|1|<point|-3|-1>>>|<line|<point|-3|2.7>|<point|-3|1.5>>|<line|<point|-1.3|2.7>|<point|-2.7|1.5>>|<line|<point|-0.7|2.7>|<point|0|1.5>>|<line|<point|-3|0.7>|<point|-3|-0.5>>|<line|<point|-0.2|0.7>|<point|-0.9|-0.5>>|<line|<point|0.2|0.7>|<point|0.9|-0.5>>|<with|text-at-halign|center|<text-at|<with|font-base-size|7|<with|color|red|0.01>>|<point|-3|3.6>>>|<with|text-at-halign|center|<text-at|<with|font-base-size|7|<with|color|red|0.1>>|<point|-1|3.6>>>|<with|text-at-halign|center|<text-at|<with|font-base-size|7|<with|color|red|0.0001>>|<point|1|-1.5>>>>>

        \;
      </with>
    </shown>|<\hidden>
      \;

      <\with|par-mode|center>
        <with|gr-mode|<tuple|edit|text-at>|gr-frame|<tuple|scale|1cm|<tuple|0.599999gw|0.3gh>>|gr-geometry|<tuple|geometry|0.481473par|0.392872par|center>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|10|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-text-at-halign|center|gr-color|red|<graphics|<with|text-at-halign|center|<text-at|<math|0.51>|<point|-3|3>>>|<with|text-at-halign|center|<text-at|<math|6.5>|<point|-1|3>>>|<with|text-at-halign|center|<text-at|<math|6.00>|<point|0|1>>>|<with|text-at-halign|center|<text-at|2.00|<point|-1|-1>>>|<with|text-at-halign|center|<text-at|<math|3.0000>|<point|1|-1>>>|<with|text-at-halign|center|<text-at|0<math|.540>|<point|-3|1>>>|<with|text-at-halign|center|<text-at|1.000|<point|-3|-1>>>|<line|<point|-3|2.7>|<point|-3|1.5>>|<line|<point|-1.3|2.7>|<point|-2.7|1.5>>|<line|<point|-0.7|2.7>|<point|0|1.5>>|<line|<point|-3|0.7>|<point|-3|-0.5>>|<line|<point|-0.2|0.7>|<point|-0.9|-0.5>>|<line|<point|0.2|0.7>|<point|0.9|-0.5>>|<with|text-at-halign|center|<text-at|<with|font-base-size|7|<with|color|red|0.01>>|<point|-3|3.6>>>|<with|text-at-halign|center|<text-at|<with|font-base-size|7|<with|color|red|0.1>>|<point|-1|3.6>>>|<with|text-at-halign|center|<text-at|<with|font-base-size|7|<with|color|red|0.0001>>|<point|1|-1.5>>>>>

        \;
      </with>
    </hidden>>

    \;
  </hidden>|<\hidden>
    <tit|Results>

    <unroll|<\shown>
      <strong|Doubling computation time approach>

      <\itemize>
        <item>Final complexity <abbr|vs.> total complexity
        <math|t<rsup|fin>\<leqslant\>t\<leqslant\>(log<rsub|2>
        t<rsup|fin>)*t<rsup|fin>>.

        <item>Final complexity <abbr|vs.> optimal complexity
        <math|t<rsup|opt>\<leqslant\>t<rsup|fin>\<leqslant\>2*s*t<rsup|opt>>.
      </itemize>
    </shown>|<\hidden*>
      <strong|Faster approaches in ``the rigid case''>

      <\itemize>
        <item>Rigid dag: for each <math|x<rsub|\<alpha\>>=f<rsub|\<alpha\>>(x<rsub|\<alpha\>[1]>,\<ldots\>,x<rsub|\<alpha\>[\|\<alpha\>\|]>)>,
        the <math|\<partial\> x<rsub|\<alpha\>>/\<partial\>
        x<rsub|\<alpha\>[i]>> are known with a fixed relative precision (say
        <math|1/2>).

        <item>A sufficient precision can be determined quite sharply
        beforehand (<name|Irram>).

        <item>Using backward error bounds and balancing, the precisions can
        be adapted locally in a quasi-optimal way.
      </itemize>
    </hidden*>>
  </hidden>>
</body>

<\initial>
  <\collection>
    <associate|page-screen-top|5mm>
    <associate|prog-scripts|maxima>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|auto-1|<tuple|1|?>>
    <associate|tfin-t-bound|<tuple|1|?>>
  </collection>
</references>