<TeXmacs|2.1.2>

<style|ims>

<\body>
  <screens|<shown|<\with-screen-color|<pattern|singapore-bright.jpg|100%|100%>>
    \;

    <\with|par-mode|center>
      <tabular*|<tformat|<cwith|1|3|1|1|cell-bsep|2.5spc>|<cwith|3|3|1|1|cell-tsep|3spc>|<table|<row|<cell|<with|font-base-size|15|strong-sunny-font-color|pastel
      orange|<strong|<with|color|orange|Lesson 8 \V <space|-0.2spc>Valued
      fields>>>>>|<row|<cell|<with|strong-sunny-font-color|pastel
      orange|<strong|<with|color|#c06000|Joris van der
      Hoeven>>>>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|<wide-tabular|<tformat|<table|<row|<\cell>
        <htab|5mm><with|strong-sunny-font-color|pastel
        brown|<strong|<with|color|brown|IMS summer school>>>
      </cell>>>>>>>|<row|<cell|<wide-tabular|<tformat|<table|<row|<\cell>
        <htab|5mm><with|strong-sunny-font-color|pastel
        brown|<strong|<with|color|brown|Singapore, July 13, 2023>>>
      </cell>>>>>>>>>>
    </with>
  </with-screen-color>>|<\hidden>
    <tit|Valued fields>

    <\definition*>
      Let <math|K> be a field and <math|\<Gamma\>> a totally ordered abelian
      group.

      A <strong|valuation> is a map <hgroup|<math|v:K\<rightarrow\>\<Gamma\>\<cup\><around*|{|\<infty\>|}>>>
      such that

      <\itemize>
        <item><math|v<around*|(|a|)>=\<infty\>> if and only if <math|a=0>;

        <item><math|v<around*|(|a*b|)>=v<around*|(|a|)>+v<around*|(|b|)>>;

        <item><math|v<around*|(|a+b|)>\<geqslant\>min<around*|(|v<around*|(|a|)>,v<around*|(|b|)>|)>>
        with equality if <math|v<around*|(|b|)>\<neq\>v<around*|(|a|)>>.
      </itemize>

      In that case, we define

      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|5|5|cell-halign|l>|<table|<row|<cell|\<cal-O\><rsub|K>>|<cell|\<assign\>>|<cell|<around*|{|a\<in\>K\<suchthat\>v<around*|(|a|)>\<geqslant\>0|}>>|<cell|<space|1em>>|<cell|<text|the
        <strong|valuation ring>>>>|<row|<cell|<o><rsub|K>>|<cell|\<assign\>>|<cell|<around*|{|a\<in\>K\<suchthat\>v<around*|(|a|)>\<gtr\>0|}>>|<cell|>|<cell|<text|its
        <strong|maximal ideal>>>>|<row|<cell|\<b-k\><rsub|K>>|<cell|\<assign\>>|<cell|\<cal-O\><rsub|K>/<o><rsub|K>>|<cell|>|<cell|<text|its
        <strong|residue field>>>>>>>
      </equation*>
    </definition*>

    <strong|Convention.> We will usually assume that
    <math|\<Gamma\>=v<around*|(|K<rsup|\<neq\>0>|)>>.
  </hidden>|<\hidden>
    <tit|Examples>

    <unroll|<\shown>
      <\compact>
        <paragraph|Ordered fields.>Let <math|K> be an ordered field. For
        <math|x,y\<in\>K<rsup|\<neq\>0>>, we define

        <\equation*>
          <overlays-phantoms|3|3|<tabular*|<tformat|<cwith|1|-1|7|7|cell-halign|l>|<cwith|1|-1|5|5|cell-halign|r>|<cwith|1|2|3|3|cell-halign|l>|<cwith|1|2|1|1|cell-halign|r>|<table|<row|<cell|x\<preccurlyeq\>y>|<cell|\<Longleftrightarrow\>>|<cell|<around*|(|\<exists\>n\<in\><value|NN><rsup|\<gtr\>0>|)><space|1em><around*|\||x|\|>\<leqslant\>n*<around*|\||y|\|>>|<cell|<space|2em>>|<cell|<overlay-from|2|\<Gamma\>|>>|<cell|<overlay-from|2|\<assign\>|>>|<cell|<overlay-from|2|<around*|{|x/<op|\<asymp\>>\<suchthat\>x\<in\>K<rsup|\<neq\>0>|}>|>>>|<row|<cell|x\<asymp\>y>|<cell|\<Longleftrightarrow\>>|<cell|x\<preccurlyeq\>y\<preccurlyeq\>x>|<cell|>|<cell|<overlay-from|2|v<around*|(|x|)>|>>|<cell|<overlay-from|2|\<assign\>|>>|<cell|<overlay-from|2|x/<op|\<asymp\>>|>>>|<row|<cell|>|<cell|>|<cell|>|<cell|>|<cell|<overlay-from|3|v<around*|(|x|)>\<leqslant\>v<around*|(|y|)>|>>|<cell|<overlay-from|3|\<Longleftrightarrow\>|>>|<cell|<overlay-from|3|x\<succcurlyeq\>y|>>>>>>>
        </equation*>

        \;
      </compact>
    </shown>|<\shown>
      <vspace*|0.5fn><paragraph|Hausdorff fields.>Any Hausdorff field
      <math|K> is valued as an ordered field with
      <math|\<b-k\><rsub|K>\<subseteq\><value|RR>>.
    </shown>|<\shown>
      <vspace*|0.75fn><paragraph|Well-based
      series.><math|K\<assign\>R<around*|[|<around*|[|z<rsup|\<Gamma\>>|]>|]>>,
      <math|R> field, <math|\<Gamma\>> totally ordered group.

      <\eqnarray*>
        <tformat|<table|<row|<cell|z<rsup|\<alpha\>>\<succcurlyeq\>z<rsup|\<beta\>>>|<cell|\<Longleftrightarrow\>>|<cell|\<alpha\>\<leqslant\>\<beta\>>>|<row|<cell|<space|7em>v<around*|(|f|)>>|<cell|\<assign\>>|<cell|\<alpha\>,<space|5em><text|for
        <math|<around*|\<nobracket\>|f\<in\>K<rsup|\<neq\>0>|\<nobracket\>>>
        with <math|<around*|\<nobracket\>|\<frak-d\><rsub|f>=x<rsup|\<alpha\>>|\<nobracket\>>>.>>>>>
      </eqnarray*>
    </shown>|<\shown>
      <vspace*|fn><paragraph|<math|p>-adic
      numbers.><math|K=<value|QQ><rsub|p>>,
      <math|\<Gamma\>\<assign\><value|ZZ>>, <math|p>-adic valuation.
    </shown>>
  </hidden>|<\hidden>
    <tit|Asymptotic relations>

    Let <math|K> be a valued field. For <math|x,y\<in\>K>, we define

    <\eqnarray*>
      <tformat|<table|<row|<cell|x\<prec\>y>|<cell|\<Longleftrightarrow\>>|<cell|v<around*|(|x|)>\<gtr\>v<around*|(|y|)>\<Longleftrightarrow\>x\<in\><o>*y\<wedge\>y\<neq\>0>>|<row|<cell|x\<preccurlyeq\>y>|<cell|\<Longleftrightarrow\>>|<cell|v<around*|(|x|)>\<geqslant\>v<around*|(|y|)>\<Longleftrightarrow\>x\<in\><O>*y>>|<row|<cell|x\<asymp\>y>|<cell|\<Longleftrightarrow\>>|<cell|v<around*|(|x|)>=v<around*|(|y|)>\<Longleftrightarrow\>x\<preccurlyeq\>y\<preccurlyeq\>x>>|<row|<cell|x\<sim\>y>|<cell|\<Longleftrightarrow\>>|<cell|x-y\<prec\>x.>>>>
    </eqnarray*>

    <strong|Note.> The axioms of valued fields can be reformulated in terms
    of <math|\<preccurlyeq\>>.

    <phantom|<strong|Note.>> Both points of views are essentially equivalent.

    <phantom|<strong|Note.>> Always remind the reversal of the ordering.
  </hidden>|<\hidden>
    <tit|Monomial groups>

    <unroll|<\shown>
      Let <math|K> be a valued field.<vspace|0.5fn>
    </shown>|<\shown>
      <\compact>
        A<strong| monomial group> for <math|K> is a subgroup
        <math|\<frak-M\>\<subseteq\>K<rsup|\<neq\>0>> such that
        <math|v<rsub|\<divides\>\<frak-M\>>> is a bijection.

        Given <math|\<gamma\>\<in\>\<Gamma\>>, we define
        <math|\<frak-z\><rsup|\<gamma\>>> to be the unique element in
        <math|\<frak-M\>> with <math|v<around*|(|\<frak-z\><rsup|\<gamma\>>|)>=\<gamma\>>.<vspace|0.5fn>
      </compact>
    </shown>|<\shown>
      <\proposition*>
        Let <math|G\<subseteq\>K<rsup|\<neq\>0>> be divisible with
        <math|v<around*|(|G|)>=\<Gamma\>>. Then there is a monomial group
        <math|\<frak-M\>\<subseteq\>G> for <math|K>.
      </proposition*>
    </shown>|<\shown>
      <\compressed>
        <vspace*|0.5fn><strong|Proof. >Embed increasingly large subgroups
        <math|\<Delta\>> of <math|\<Gamma\>> into <math|G>.

        Given <math|<around*|\<nobracket\>|\<Gamma\>\<varsupsetneq\>\<Delta\>|\<nobracket\>>\<longhookrightarrow\>G>
        and <math|\<gamma\>\<in\>\<Gamma\>\<setminus\>\<Delta\>>, let
        <math|k\<in\><value|NN>> with <math|k*<value|ZZ>=<around*|{|n\<in\><value|ZZ>\<suchthat\>n*\<gamma\>\<in\>\<Delta\>|}>>.

        Take <math|\<frak-z\><rsup|\<gamma\>>\<in\>G> with
        <math|v<around*|(|\<frak-z\><rsup|\<gamma\>>|)>=\<gamma\>> such that
        <math|<around*|(|\<frak-z\><rsup|\<gamma\>>|)><rsup|k>=\<frak-z\><rsup|k*\<gamma\>>>
        whenever <math|k\<gtr\>0>. Apply Zorn.<htab|5mm><qed>
      </compressed>
    </shown>|<\shown>
      <paragraph|Examples:>

      <\itemize>
        <unroll|<\shown>
          <item><math|G=K<rsup|\<neq\>0>> for an algebraically closed valued
          field <math|K>.
        </shown>|<\shown>
          <item><math|G=K<rsup|\<gtr\>0>> for a real closed field <math|K>.
        </shown>>
      </itemize>
    </shown>>

    \;
  </hidden>|<\hidden>
    <tit|Newton polynomials>

    <\compact>
      Let <math|K> be a valued field and <math|P\<in\>K<around*|[|Y|]><rsup|\<neq\>0>>.
      We extend the valuation <math|v> to <math|K<around*|[|Y|]>> by

      <\equation*>
        v<around*|(|P<rsub|d>*Y<rsup|d>+\<cdots\>+P<rsub|0>|)>\<assign\>min
        <around*|(|v<around*|(|P<rsub|d>|)>,\<ldots\>,v<around*|(|P<rsub|0>|)>|)>.
      </equation*>
    </compact>

    <\compact>
      <vspace*|0.5fn>We also define the relation <math|\<propto\>> on
      <math|\<b-k\><around*|[|Y|]>> by

      <\equation*>
        A\<propto\>B\<Longleftrightarrow\><around*|\<nobracket\>|<around*|(|\<exists\>\<lambda\>\<in\>\<b-k\><rsup|\<neq\>0>|)><space|1.2spc>B=\<lambda\>*A|\<nobracket\>>.
      </equation*>
    </compact>

    <\compact>
      <vspace*|0.5fn>The <strong|projective Newton polynomial>
      <math|N<rsub|\<propto\>><around*|(|P|)>\<in\>\<b-k\><around*|[|Y|]>/<op|\<propto\>>>
      is defined by

      <\equation*>
        <space|8em>N<rsub|\<propto\>><around*|(|P|)>\<assign\><wide|a*P|\<bar\>>/<op|\<propto\>>,<space|2em><text|where
        <math|<around*|\<nobracket\>|a\<in\>K|\<nobracket\>>> is such that
        <math|<around*|\<nobracket\>|a*P\<asymp\>1|\<nobracket\>>>.>
      </equation*>
    </compact>

    <\compact>
      <vspace*|0.7fn>The <strong|monic Newton polynomial>
      <math|N<rsub|mon><around*|(|P|)>\<in\>\<b-k\><around*|[|Y|]>> is the
      monic polynomial with

      <\equation*>
        N<rsub|mon><around*|(|P|)>/<op|\<propto\>>=N<rsub|\<propto\>><around*|(|P|)>
      </equation*>
    </compact>

    <\compact>
      <vspace*|0.7fn>If <math|K> has a monomial group, then we define the
      <strong|Newton polynomial> <math|N<around*|(|P|)>\<in\>\<b-k\><around*|[|Y|]>>
      by

      <\equation*>
        N<around*|(|P|)>\<assign\><wide|\<frak-z\><rsup|-v<around*|(|P|)>>*P|\<bar\>>.
      </equation*>
    </compact>
  </hidden>|<\hidden>
    <tit|Newton degree>

    Given <math|P\<in\>K<around*|[|Y|]>> and <math|\<gamma\>\<in\>\<Gamma\>>,
    one may consider the asymptotic equation

    <\eqnarray*>
      <tformat|<table|<row|<cell|P<around*|(|y|)>>|<cell|=>|<cell|0,<space|2em>v<around*|(|y|)>\<gtr\>\<gamma\>.>>>>
    </eqnarray*>

    The <strong|Newton degrees> of this equation is defined by

    <\eqnarray*>
      <tformat|<table|<row|<cell|deg<rsub|\<gtr\>\<gamma\>>
      P>|<cell|\<assign\>>|<cell|val N<rsub|\<propto\>><around*|(|P<rsub|\<times\>a>|)>>>>>
    </eqnarray*>

    where <math|a\<in\>K<rsup|\<neq\>0>> is such that
    <math|v<around*|(|a|)>=\<gamma\>>.<vspace|0.5fn>

    Equations of Newton degree one are said to be <strong|quasi-linear>.

    <\definition*>
      We say that <math|K> is <strong|henselian> if any quasi-linear equation
      has a solution in <math|K>.
    </definition*>
  </hidden>|<\hidden>
    <tit|The Newton polygon method>

    <unroll|<\shown>
      Let <math|K> be a henselian valued field of characteristic zero with a
      divisible value group<nbsp><math|\<Gamma\>>.
    </shown>|<\shown>
      <\theorem*>
        <\compressed>
          Let <math|P\<in\>K<around*|[|Y|]><rsup|\<neq\>0>> and
          <math|\<gamma\>\<in\>\<Gamma\>>. If <math|\<b-k\>> is algebraically
          closed, then

          <\equation*>
            P<around*|(|y|)>=0,<space|2em>v<around*|(|y|)>\<gtr\>\<gamma\>
          </equation*>

          has exactly <math|deg<rsub|\<gtr\>\<gamma\>> P> solutions in
          <math|K>, when counting with multiplicities.
        </compressed>
      </theorem*>
    </shown>|<\shown>
      <switch|<\hidden>
        <vspace*|0.5fn><strong|Proof.> Straightforward adaptation of proof
        from Lesson 4.<htab|5mm><qed>
      </hidden>|<\shown>
        <unroll|<\shown>
          <\corollary*>
            <\enumerate-alpha>
              <item>If <math|\<b-k\>> is algebraically closed, then so is
              <math|K>.

              <item>If <math|\<b-k\>> is real closed, then so is <math|K>.
            </enumerate-alpha>
          </corollary*>
        </shown>|<\shown>
          <\compressed>
            <unroll|<\shown>
              <vspace*|0.4fn><strong|Proof of (<em|b>).> Since
              <math|\<b-k\><around*|[|\<mathi\>|]>> is algebraically closed,
              so is <math|K<around*|[|\<mathi\>|]>>, by (<em|a>).
            </shown>|<\shown>
              The complex roots of <math|P> in
              <math|K<around*|[|\<mathi\>|]>> come in conjugate pairs.
            </shown>|<\shown>
              If <math|deg P> is odd, this means that <math|P> has at least
              one root in <math|K>.<htab|5mm><qed>
            </shown>>
          </compressed>
        </shown>>
      </shown>>
    </shown>>
  </hidden>|<\hidden>
    <tit|Adjoining single elements to valued fields>

    <switch|<\hidden>
      Given a valued field <math|K>, describe the valued field extensions
      <math|L\<assign\>K<around*|(|y|)>\<supseteq\>K>.<vspace|1fn>

      <unroll|<\shown>
        <\wide-tabular>
          <tformat|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|2|2|cell-valign|t>|<table|<row|<\cell>
            <with|gr-mode|<tuple|edit|line>|gr-frame|<tuple|scale|1cm|<tuple|0.5gw|0.5gh>>|gr-geometry|<tuple|geometry|0.243457par|0.252167par|center>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|10|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-text-at-repulse|1spc|gr-text-at-halign|center|gr-text-at-valign|center|gr-arrow-end|\<gtr\>|<graphics||<with|text-at-valign|center|text-at-repulse|1spc|text-at-halign|center|<math-at|K|<point|0|-1>>>|<with|text-at-valign|center|text-at-repulse|1spc|text-at-halign|center|<math-at|K<around*|(|y|)>|<point|0|1>>>|<with|arrow-end|\<gtr\>|<line|<point|0|-1>|<point|0.0|1.0>>>>>
          </cell>|<\cell>
            <unroll|<\shown>
              <tiny-switch|<hidden|>|<shown|<strong|2 \<times\> 3 fundamental
              kinds of extensions><vspace|0.25fn>>>
            </shown>|<\shown>
              <\itemize>
                <unroll|<\shown>
                  <item><math|y> is algebraic.
                </shown>|<\shown>
                  <item><math|y> is transcendental.<vspace|0.5fn>
                </shown>|<\shown>
                  <item><math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>,
                  <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>>
                  (<math|L\<supseteq\>K> is called an <strong|immediate
                  extension>).
                </shown>|<\shown>
                  <item><math|\<b-k\><rsub|L>\<varsubsetneq\>\<b-k\><rsub|K>>,
                  <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>> with
                  <math|y\<preccurlyeq\>1> and
                  <math|\<b-k\><rsub|L>=\<b-k\><rsub|K><around*|(|<wide|y|\<bar\>>|)>>.
                </shown>|<\shown>
                  <item><math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>,
                  <math|\<Gamma\><rsub|L>\<varsubsetneq\>\<Gamma\><rsub|K>>
                  with <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>+v<around*|(|y|)>*<value|ZZ>>.
                </shown>>
              </itemize>
            </shown>>
          </cell>>>>
        </wide-tabular>
      </shown>|<\shown>
        <vspace*|0.75fn>How unique is the extension
        <math|K\<subseteq\>K<around*|(|y|)>><space|0.4spc>?<vspace|0.25fn>
      </shown>>
    </hidden>|<\shown>
      Given a valued field <math|K>, describe the valued field extensions
      <math|L\<assign\>K<around*|(|y|)>\<supseteq\>K>.<vspace|1fn>

      <\wide-tabular>
        <tformat|<cwith|1|1|2|2|cell-hpart|1>|<cwith|1|1|2|2|cell-valign|t>|<table|<row|<\cell>
          <with|gr-mode|<tuple|edit|math-at>|gr-frame|<tuple|scale|1cm|<tuple|0.5gw|0.5gh>>|gr-geometry|<tuple|geometry|0.243457par|0.252167par|center>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|10|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-text-at-repulse|1spc|gr-text-at-halign|center|gr-text-at-valign|center|gr-arrow-end|\<gtr\>|gr-dash-style|10|<graphics||<with|text-at-valign|center|text-at-repulse|1spc|text-at-halign|center|<math-at|K|<point|0|-1>>>|<with|text-at-valign|center|text-at-repulse|1spc|text-at-halign|center|<math-at|K<around*|(|y|)>|<point|-1.0|1.0>>>|<with|arrow-end|\<gtr\>|<line|<point|0|-1>|<point|-1.0|1.0>>>|<with|text-at-valign|center|text-at-repulse|1spc|text-at-halign|center|<math-at|F|<point|1|1>>>|<with|arrow-end|\<gtr\>|<line|<point|0|-1>|<point|1.0|1.0>>>|<with|arrow-end|\<gtr\>|dash-style|10|<line|<point|-1|1>|<point|1.0|1.0>>>|<with|text-at-valign|center|text-at-repulse|1spc|text-at-halign|center|<math-at|<small|\<varphi\>>|<point|0|1.2>>>>>
        </cell>|<\cell>
          <unroll|<\shown>
            <strong|2 \<times\> 3 fundamental kinds of
            extensions><vspace|0.25fn>

            <\itemize>
              <item><math|y> is algebraic.

              <item><math|y> is transcendental.<vspace|0.5fn>

              <item><math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>,
              <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>>
              (<math|L\<supseteq\>K> is called an <strong|immediate
              extension>).

              <item><math|\<b-k\><rsub|L>\<varsubsetneq\>\<b-k\><rsub|K>>,
              <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>> with
              <math|y\<preccurlyeq\>1> and
              <math|\<b-k\><rsub|L>=\<b-k\><rsub|K><around*|(|<wide|y|\<bar\>>|)>>.

              <item><math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>,
              <math|\<Gamma\><rsub|L>\<varsubsetneq\>\<Gamma\><rsub|K>> with
              <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>+v<around*|(|y|)>*<value|ZZ>>.
            </itemize>
          </shown>>
        </cell>>>>
      </wide-tabular>

      <vspace*|0.75fn>How unique is the extension
      <math|K\<subseteq\>K<around*|(|y|)>><space|0.4spc>?<vspace|0.25fn>

      <\compact>
        Given a valued field extension <math|F\<supseteq\>K> and
        <math|a\<in\>F> of \Psame type over <math|K>\Q as <math|y>,

        does there exist a unique embedding of valued fields
        <math|\<varphi\>:K<around*|(|y|)>\<rightarrow\>F> with
        <math|\<varphi\><around*|(|y|)>=a><space|0.6spc>?
      </compact>
    </shown>>
  </hidden>|<\hidden>
    <tit|Pseudo-convergence>

    <unroll|<\shown>
      Let <math|<around*|(|a<rsub|\<rho\>>|)><rsub|\<rho\>\<less\>\<alpha\>>\<in\>K<rsup|\<alpha\>>>
      or shortly <math|<around*|(|a<rsub|\<rho\>>|)>> be a sequence indexed
      by ordinals smaller than <math|\<alpha\>>.<vspace|0.5fn>
    </shown>|<\shown>
      <\compact>
        We say that <math|<around*|(|a<rsub|\<rho\>>|)>> is a
        <strong|pseudo-cauchy sequence> (pc-sequence) if

        <\equation*>
          <around*|(|\<exists\>\<rho\><rsub|0>|)><space|1em><around*|(|\<forall\>\<tau\>\<gtr\>\<sigma\>\<gtr\>\<rho\>\<gtr\>\<rho\><rsub|0>|)><space|1em>a<rsub|\<tau\>>-a<rsub|\<sigma\>>\<prec\>a<rsub|\<sigma\>>-a<rsub|\<rho\>>.
        </equation*>
      </compact>
    </shown>|<\shown>
      <\compact>
        <unroll|<\shown>
          <vspace*|0.5fn>We say that <math|<around*|(|a<rsub|\<rho\>>|)>>
          <strong|pseudo-converges> to <math|a\<in\>K> (notation:
          <math|a<rsub|\<rho\>>\<rightsquigarrow\>a>), if

          <\equation*>
            <around*|(|\<exists\>\<rho\><rsub|0>|)><space|1em><around*|(|\<forall\>\<sigma\>\<gtr\>\<rho\>\<gtr\>\<rho\><rsub|0>|)><space|1em>a-a<rsub|\<sigma\>>\<prec\>a-a<rsub|\<rho\>>.
          </equation*>
        </shown>|<\shown>
          <\itemize>
            <item><math|1>, <math|1+x<rsup|-1>>,
            <math|1+x<rsup|-1>+x<rsup|-2>,> <math|\<ldots\>> pseudo-converges
            to <math|1+x<rsup|-1>+x<rsup|-2>+\<cdots\>> in
            <math|<value|R><around*|[|<around*|[|x;\<mathe\><rsup|x>|]>|]>>.

            <item>It also converges to <math|1+x<rsup|-1>+x<rsup|-2>+\<cdots\>>
            in <math|<value|R><around*|[|<around*|[|x<rsup|-1>|]>|]>>, but
            not in <math|<value|R><around*|[|<around*|[|x;\<mathe\><rsup|x>|]>|]>>.<vspace|1fn>
          </itemize>
        </shown>>
      </compact>
    </shown>|<\shown>
      <\compact>
        <unroll|<\shown>
          If <math|<around*|(|a<rsub|\<rho\>>|)>> <strong|pseudo-diverges>,
          then<vspace|0.25fn>
        </shown>|<\shown>
          <\itemize>
            <unroll|<\shown>
              <item><math|<around*|(|a<rsub|\<rho\>>|)>> is of
              <strong|algebraic type> if there exists a
              <math|P\<in\>K<around*|[|Y|]>> with
              <math|P<around*|(|a<rsub|\<rho\>>|)>\<rightsquigarrow\>0>
            </shown>|<\shown>
              <item>Otherwise, <math|<around*|(|a<rsub|\<rho\>>|)>> is of
              <strong|transcendental type>.<vspace|0.5fn>
            </shown>>
          </itemize>
        </shown>>
      </compact>
    </shown>>

    \;
  </hidden>|<\hidden>
    <tit|Transcendental immediate extensions>

    <unroll|<\shown>
      <\render-theorem|Lemma TR-IMM>
        <\compact>
          Let <math|<around*|(|a<rsub|\<rho\>>|)>> be pseudo-divergent of
          transcendental type. Then <math|v> extends to
          <hgroup|<math|K<around*|(|Y|)>>> via

          <\equation*>
            v<around*|(|P|)>\<assign\><math-ordinary|<text|eventual value of
            <math|v<around*|(|P<around*|(|a<rsub|\<rho\>>|)>|)>>>>,<space|2em><text|for
            any ><around*|\<nobracket\>|P\<in\>K<around*|[|Y|]>|\<nobracket\>>.
          </equation*>

          The extension <math|L\<assign\>K<around*|(|Y|)>\<supseteq\>K> is
          immediate and <math|a<rsub|\<rho\>>\<rightsquigarrow\>Y> in
          <math|L>. Moreover, if <math|a<rsub|\<rho\>>\<rightsquigarrow\>a>
          in another immediate extension <math|F\<supseteq\>K>, then there is
          a unique embedding <math|\<varphi\>:L\<rightarrow\>F> over <math|K>
          with <hgroup|<math|\<varphi\><around*|(|Y|)>=a>>.
        </compact>
      </render-theorem>
    </shown>|<\shown>
      <\compact>
        <unroll|<\shown>
          <strong|Proof.> Easy: our formula for <math|v<around*|(|P|)>>
          yields a valuation with <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>>
          and <math|a<rsub|\<rho\>>\<rightsquigarrow\>Y>.<vspace|0.5fn>
        </shown>|<\shown>
          Given <math|P\<in\>K<around*|[|Y|]>> with
          <math|v<around*|(|P|)>=0>, let us show that
          <math|<wide|P|\<bar\>>\<in\>\<b-k\><rsub|K>>.
          <tiny-switch|<hidden|>|<shown|This will imply
          <math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>.>>
        </shown>|<\shown>
          We have, <math|v<around*|(|P<around*|(|a<rsub|\<rho\>>|)>|)>=0> and
          <math|v<around*|(|P-P<around*|(|a<rsub|\<rho\>>|)>|)>\<gtr\>0>,
          eventually.
        </shown>|<\shown>
          Let <math|c=P<around*|(|a<rsub|\<rho\>>|)>\<in\>K> with
          <math|v<around*|(|c|)>=0> and <math|v<around*|(|P-c|)>\<gtr\>0>.
          Then <math|<wide|P|\<bar\>>=<wide|c|\<bar\>>\<in\>\<b-k\><rsub|K>>.<vspace|0.5fn>
        </shown>|<\shown>
          If <math|a<rsub|\<rho\>>\<rightsquigarrow\>a> in
          <math|F\<supseteq\>K> and <math|P\<in\>K<around*|[|Y|]>\<setminus\>K>,
          then <math|P<around*|(|a<rsub|\<rho\>>|)>\<rightsquigarrow\>P<around*|(|a|)>>,
          by Taylor expansion around <math|a>.
        </shown>|<\shown>
          Hence, <math|v<around*|(|P<around*|(|a|)>|)>=v<around*|(|P<around*|(|a<rsub|\<rho\>>|)>|)>=v<around*|(|P|)>>,
          eventually, so <math|P<around*|(|a|)>\<neq\>0> and <math|a> is
          transcendental.
        </shown>|<\shown>
          We conclude that <math|\<exists\>!> ring morphism
          <math|\<varphi\>:L\<rightarrow\>F> with
          <math|\<varphi\><around*|(|Y|)>=a> and <math|\<varphi\>> preserves
          <math|v>.<htab|5mm><qed>
        </shown>>
      </compact>
    </shown>>
  </hidden>|<\hidden>
    <tit|Algebraic immediate extensions>

    <unroll|<\shown>
      <\render-theorem|Lemma ALG-IMM>
        <\compact>
          Let <math|<around*|(|a<rsub|\<rho\>>|)>> be pseudo-divergent of
          algebraic type. Let <math|\<mu\>\<in\>K<around*|[|Y|]>> be of
          minimal degree <math|d> with <math|\<mu\><around*|(|a<rsub|\<rho\>>|)>\<rightsquigarrow\>0>.
          Let <math|L\<assign\>K<around*|[|Y|]>/<around*|(|\<mu\>|)>>,
          <math|y\<assign\>Y+<around*|(|\<mu\>|)>>,
          <math|K<around*|[|Y|]><rsub|d>\<assign\><around*|{|P\<in\>K<around*|[|Y|]>\<suchthat\>deg
          P\<less\>d|}>>. Then

          <\equation*>
            v<around*|(|P<around*|(|y|)>|)>\<assign\><math-ordinary|<text|eventual
            value of <math|v<around*|(|P<around*|(|a<rsub|\<rho\>>|)>|)>>>>,<space|2em><text|for
            any <math|<around*|\<nobracket\>|P\<in\>K<around*|[|Y|]><rsub|d>|\<nobracket\>>>>
          </equation*>

          yields an extension of <math|v> to <hgroup|<math|L>>. This
          extension <math|L\<assign\>K<around*|(|Y|)>\<supseteq\>K> is
          immediate and <math|a<rsub|\<rho\>>\<rightsquigarrow\>y> in
          <math|L>. Moreover, if <math|a<rsub|\<rho\>>\<rightsquigarrow\>a>
          and <math|\<mu\><around*|(|a|)>=0> for <math|a> in another
          immediate extension <math|F\<supseteq\>K>, there is a unique
          embedding <math|\<varphi\>:L\<rightarrow\>F> over <math|K> with
          <math|\<varphi\><around*|(|y|)>=a>.
        </compact>
      </render-theorem>
    </shown>|<\shown>
      <\compressed>
        <unroll|<\shown>
          <strong|Proof.> Mostly similar to previous lemma, except for
          <math|v<around*|(|s*t|)>=v<around*|(|s|)>+P<around*|(|t|)>> in
          <math|L<rsup|\<neq\>0>>.
        </shown>|<\shown>
          Write <math|s=S<around*|(|y|)>>, <math|t\<in\>T<around*|(|y|)>>,
          <math|<around*|\<nobracket\>|S,T|\<nobracket\>>\<in\>K<around*|[|Y|]><rsub|d>>.
          <math|S*T\<backassign\>Q*\<mu\>+R>,
          <math|R\<in\>K<around*|[|Y|]><rsub|d>>, so that
          <math|R<around*|(|y|)>=s*t>.
        </shown>|<\shown>
          Eventually, <math|v<around*|(|s*t|)>=v<around*|(|R<around*|(|a<rsub|\<rho\>>|)>|)>>
          <tiny-switch|<hidden|>|<shown|and
          <math|v<around*|(|s|)>+v<around*|(|t|)>=v<around*|(|S<around*|(|a<rsub|\<rho\>>|)>*T<around*|(|a<rsub|\<rho\>>|)>|)>=v<around*|(|Q<around*|(|a<rsub|\<rho\>>|)>*\<mu\><around*|(|a<rsub|\<rho\>>|)>+R<around*|(|a<rsub|\<rho\>>|)>|)>>.>>
        </shown>|<\shown>
          But <math|Q<around*|(|a<rsub|\<rho\>>|)>*\<mu\><around*|(|\<alpha\><rsub|\<rho\>>|)>>
          is eventually increasing or eventually infinite.
        </shown>|<\shown>
          Eventually, this yields <math|v<around*|(|Q<around*|(|a<rsub|\<rho\>>|)>*\<mu\><around*|(|a<rsub|\<rho\>>|)>|)>\<gtr\>v<around*|(|R<around*|(|a<rsub|\<rho\>>|)>|)>>
          and <math|v<around*|(|s|)>+v<around*|(|t|)>=v<around*|(|R<around*|(|a<rsub|\<rho\>>|)>|)>=v<around*|(|s*t|)>>.<htab|5mm><qed>
        </shown>>
      </compressed>
    </shown>>
  </hidden>|<\hidden>
    <tit|Spherical completion>

    <unroll|<\shown>
      <\definition*>
        A valued field <math|K> is said to be <strong|spherically complete>
        if every pc-sequence <hgroup|pseudo-converges>.
      </definition*>
    </shown>|<\shown>
      <vspace*|0.5fn><strong|Example.> If <math|R> is a field and
      <math|\<frak-M\>> totally ordered, then
      <math|R<around*|[|<around*|[|\<frak-M\>|]>|]>> is sperically
      complete.<vspace|0.75fn>
    </shown>|<\shown>
      <\theorem*>
        Any valued field <math|K> has a unique immediate spherical
        completion, up to isomorphism.
      </theorem*>
    </shown>|<\shown>
      <vspace*|0.25fn><strong|Proof.> Combine Lemmas<nbsp>TR-IMM
      and<nbsp>ALG-IMM, and apply Zorn.<htab|5mm><qed>
    </shown>>

    \;

    \;
  </hidden>|<\hidden>
    <tit|Henselization>

    <unroll|<\shown>
      <\definition*>
        A valued field <math|K> is said to be <strong|algebraically maximal>
        if it does not admit any proper immediate algebraic valued field
        extension.
      </definition*>
    </shown>|<\shown>
      <strong|Examples.> Any algebraically closed or spherically complete
      valued field.
    </shown>|<\shown>
      <\theorem*>
        Any valued field <math|K> has a unique algebraically maximal
        extension, up to isomorphism.
      </theorem*>
    </shown>|<\shown>
      <vspace*|0.25fn><strong|Proof.> Use Lemma ALG-IMM and
      Zorn.<vspace|0.25fn><htab|5mm><qed>
    </shown>|<\shown>
      <switch|<\hidden>
        <unroll|<\shown>
          <\proposition*>
            If <math|K> is algebraically maximal, then <math|K> is henselian.
          </proposition*>
        </shown>|<\shown>
          <strong|Proof.> Any quasi-linear
          <math|y=P<around*|(|y|)>,<space|0.6spc>y\<prec\>1> with no solution
          in <math|K> gives rise to a divergent pc-sequence
          <math|<around*|(|a<rsub|\<rho\>>|)>> with
          <math|P<around*|(|a<rsub|\<rho\>>|)>\<rightsquigarrow\>0>:
          <math|a<rsub|0>=0>, <math|a<rsub|\<alpha\>+1>=P<around*|(|a<rsub|\<alpha\>>|)>>,
          <math|a<rsub|\<lambda\>>\<assign\>\<ell\>>, whenever
          <math|<around*|(|a<rsub|\<alpha\>>|)><rsub|\<alpha\>\<less\>\<lambda\>>\<rightsquigarrow\>\<ell\>>.<htab|5mm><qed>
        </shown>>
      </hidden>|<\shown>
        <unroll|<\shown>
          <\proposition*>
            If <math|char K=char \<b-k\>=0>, then <math|K> is algebraically
            maximal iff <math|K> is henselian.
          </proposition*>
        </shown>|<\shown>
          <strong|Proof.> By what precedes and Newton polygon
          method.<htab|5mm><qed>
        </shown>>
      </shown>>
    </shown>>
  </hidden>|<\hidden>
    <tit|Adjoining transcendental residues>

    <\render-theorem|Lemma TR-RES>
      <\compact>
        Define <math|v:K<around*|(|Y|)><rsup|\<neq\>0>\<rightarrow\>\<Gamma\>>
        with <math|v<around*|(|P/Q|)>=v<around*|(|P|)>-v<around*|(|Q|)>> for
        <math|P,Q\<in\>K<around*|[|Y|]><rsup|\<neq\>0>> and

        <\equation*>
          v<around*|(|P|)>=min<around*|(|v<around*|(|P<rsub|0>|)>,\<ldots\>,v<around*|(|P<rsub|d>|)>|)>,<space|2em><text|for
          any <math|<around*|\<nobracket\>|P=P<rsub|d>*Y<rsup|d>+\<cdots\>+P<rsub|0>\<in\>K<around*|[|Y|]>|\<nobracket\>>>.>
        </equation*>

        Then <math|L\<assign\>K<around*|(|Y|)>\<supseteq\>K> is a valued
        field extension with <math|\<b-k\><rsub|L>=\<b-k\><around*|(|<wide|Y|\<bar\>>|)>>
        and <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>>.
      </compact>

      For any valued field extension <math|F\<supseteq\>K> with
      <math|\<Gamma\><rsub|F>=\<Gamma\><rsub|K>> and
      <math|a\<in\><O><rsub|L>> such that <math|<wide|a|\<bar\>>> is
      transcendental over <math|\<b-k\><rsub|K>>, there exists a unique
      valued field embedding <math|\<varphi\>:L\<rightarrow\>F> over <math|K>
      with <math|\<varphi\><around*|(|Y|)>=a>.
    </render-theorem>

    <\compressed>
      <strong|Proof.> <math|L\<supseteq\>K> is easily seen to be a valued
      field extension. Clearly, <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>>.

      Consider <math|A\<in\>L> with <math|v<around*|(|A|)>=0>. We claim that
      <math|<wide|A|\<bar\>>\<in\>\<b-k\><around*|(|<wide|Y|\<bar\>>|)>>,
      which proves <math|\<b-k\><rsub|L>=\<b-k\><around*|(|<wide|Y|\<bar\>>|)>>.

      <\indent>
        Indeed, <math|A=P/Q> with <math|P,Q\<in\>K<around*|[|Y|]>> such that
        <math|v<around*|(|P|)>=v<around*|(|Q|)>=0>.
      </indent>

      <\indent>
        Then <math|<wide|P|\<bar\>>,<wide|Q|\<bar\>>\<in\>\<b-k\><around*|[|<wide|Y|\<bar\>>|]><rsup|\<neq\>0>>,
        so <math|<wide|A|\<bar\>>=<wide|P|\<bar\>>/<wide|Q|\<bar\>>\<in\>\<b-k\><around*|(|<wide|Y|\<bar\>>|)>>.
      </indent>

      <math|Y>, <math|a> transcendental over <math|K>
      <math|\<Longrightarrow\>> <math|\<exists\>!> field embedding
      <math|L\<rightarrow\>F> over <math|K> with
      <math|\<varphi\><around*|(|Y|)>=a>.

      <math|v<around*|(|a|)>=0> <math|\<Longrightarrow\>>
      <math|v<around*|(|P<around*|(|a|)>|)>=min<around*|(|v<around*|(|P<rsub|0>|)>,\<ldots\>,v<around*|(|P<rsub|d>|)>|)>>
      for any <math|P=P<rsub|d>*Y<rsup|d>+\<cdots\>+P<rsub|0>\<in\>K<around*|[|Y|]>>.<htab|5mm><qed>
    </compressed>
  </hidden>|<\hidden>
    <tit|Adjoining algebraic residues>

    <\render-theorem|Lemma ALG-RES>
      <\compact>
        Let <math|\<mu\>\<in\>K<around*|[|Y|]>> with
        <math|v<around*|(|\<mu\>|)>=0> and
        <math|<wide|\<mu\>|\<bar\>>\<in\>\<b-k\><around*|[|<wide|Y|\<bar\>>|]>>
        irreducible of degree <math|d=deg \<mu\>>. Then
        <math|y\<assign\>Y+<around*|(|\<mu\>|)>> in
        <math|L\<assign\>K<around*|[|Y|]>/<around*|(|\<mu\>|)>>. Then
        <math|L\<supseteq\>K> is a valued field extension with
        <math|\<b-k\><rsub|L>=\<b-k\><around*|[|<wide|y|\<bar\>>|]>/<around*|(|<wide|\<mu\>|\<bar\>>|)>>
        and <math|\<Gamma\><rsub|L>=\<Gamma\><rsub|K>> for

        <\equation*>
          v<around*|(|P<around*|(|y|)>|)>=min<around*|(|v<around*|(|P<rsub|0>|)>,\<ldots\>,v<around*|(|P<rsub|d-1>|)>|)>,<space|2em><text|for
          any <math|<around*|\<nobracket\>|P\<in\>K<around*|[|Y|]><rsub|d>|\<nobracket\>>>.>
        </equation*>
      </compact>

      For any valued field extension <math|F\<supseteq\>K> with
      <math|\<Gamma\><rsub|F>=\<Gamma\><rsub|K>> and
      <math|a\<in\><O><rsub|L>> such that
      <math|\<b-k\><around*|(|<wide|a|\<bar\>>|)>\<cong\>\<b-k\><rsub|L>>,
      there exists a unique valued field embedding
      <math|\<varphi\>:L\<rightarrow\>F> over <math|K> with
      <math|\<varphi\><around*|(|y|)>=a>.
    </render-theorem>

    <vspace*|0.25fn><strong|Note.> <math|\<mu\>> is irreducible in
    <math|K<around*|[|Y|]>> since <math|<wide|\<mu\>|\<bar\>>> is irreducible
    in <math|\<b-k\><around*|[|<wide|Y|\<bar\>>|]>>, by Gauss'
    lemma.<vspace|0.5fn>

    <\compressed>
      <strong|Proof.> Similar to previous lemma, except for
      <math|v<around*|(|s*t|)>=v<around*|(|s|)>+v<around*|(|t|)>> in
      <math|L>.

      Any <math|s\<in\>L> can be decomposed <math|s=u*<wide|s|~>> with
      <math|u\<in\>K> and <math|<wide|s|~>\<in\>L> such that
      <math|v<around*|(|<wide|s|~>|)>=0>.

      Without loss of generality, we may therefore assume that
      <math|v<around*|(|s|)>=v<around*|(|t|)>=0>.

      Then <math|<wide|s|\<bar\>>,<wide|t|\<bar\>>\<in\>\<b-k\><rsub|L><rsup|<smash|\<neq\>0>>>,
      so <math|<wide|s*t|\<wide-bar\>>=<wide|s|\<bar\>>*<wide|t|\<bar\>>\<in\>\<b-k\><rsub|L><rsup|<smash|\<neq\>0>>>,
      hence <math|v<around*|(|s*t|)>=0>.<htab|5mm><qed>
    </compressed>

    \;
  </hidden>|<\hidden>
    <tit|Adjoining \Ptranscendental\Q elements to <math|\<Gamma\>>>

    <\render-theorem|Lemma TR-VAL>
      <\compressed>
        Let <math|\<Delta\>\<supseteq\>\<Gamma\>> be a totally ordered group
        and <math|\<gamma\>\<in\>\<Delta\>> be such that
        <math|\<Delta\>=\<Gamma\>\<oplus\><value|ZZ>*\<gamma\>>. Then there
        is a<nbsp>unique valued field extension
        <math|L\<assign\>K<around*|(|Y|)>\<supseteq\>K> with
        <math|v<around*|(|Y|)>=\<gamma\>>. It is given by

        <\equation*>
          v<around*|(|P|)>\<assign\>min <around*|(|v<around*|(|P<rsub|0>|)>,\<ldots\>,v<around*|(|P<rsub|d>|)>+d*\<gamma\>|)>,<space|2em><text|for
          all <math|<around*|\<nobracket\>|P=P<rsub|d>*Y<rsup|d>+\<cdots\>+P<rsub|0>\<in\>K<around*|[|Y|]>|\<nobracket\>><rsup|\<neq\>0>>.>
        </equation*>

        Moreover, if <math|F\<supseteq\>K> is a valued field extension and
        <math|a\<in\>F> transcendental such that
        <math|v<around*|(|a|)>><nbsp>and<nbsp><math|\<gamma\>> lie in the
        same cut over <math|\<Gamma\>>, then <math|\<exists\>!> valued field
        embedding <math|\<varphi\>:L\<rightarrow\>F> over <math|K> with
        <hgroup|<math|\<varphi\><around*|(|a|)>=Y>>.
      </compressed>
    </render-theorem>

    <switch|<\hidden>
      <vspace*|0.5fn><strong|Exercise. >We also have
      <math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>.
    </hidden>|<\shown>
      <\compressed>
        <strong|Proof. >For <math|P=P<rsub|d>*Y<rsup|d>+\<cdots\>+P<rsub|0>\<in\>K<around*|[|Y|]><rsup|\<neq\>0>>,
        there exists exactly one <math|i> with
        <math|v<around*|(|P|)>=v<around*|(|P<rsub|i>|)>+i*\<gamma\>>.

        Given a second <math|Q\<in\>K<around*|[|Y|]><rsup|\<neq\>0>>, there
        is also exactly one <math|j> with
        <math|v<around*|(|Q|)>=v<around*|(|Q<rsub|j>|)>+j*\<gamma\>>.

        One verifies that <math|v<around*|(|P*Q|)>=v<around*|(|P<rsub|i>*Q<rsub|j>|)>+<around*|(|i+j|)>*\<gamma\>=v<around*|(|P|)>+v<around*|(|Q|)>>,
        so <math|v<rsub|L>> is a valuation on <math|L>.<vspace|0.3333fn>
      </compressed>

      <\compressed>
        <math|Y>, <math|a> transcendental over <math|K>
        <math|\<Longrightarrow\>> <math|\<exists\>!> field embedding
        <math|\<varphi\>:L\<rightarrow\>F> over <math|K> with
        <math|\<gamma\><around*|(|a|)>=Y>.

        <math|v<around*|(|P<around*|(|a|)>|)>=min<around*|(|v<around*|(|P<rsub|0>|)>,\<ldots\>,v<around*|(|P<rsub|d>|)>+d*v<around*|(|a|)>|)>>
        for all <math|<smash|P=P<rsub|d>*Y<rsup|d>+\<cdots\>+P<rsub|0>\<in\>K<around*|[|Y|]><rsup|\<neq\>0>>>.

        Hence <math|\<varphi\>> preserves <math|v>, since
        <math|v<around*|(|a|)>> and <math|\<gamma\>> lie in the same cut over
        <math|\<Gamma\>>.<htab|5mm><qed>
      </compressed>
    </shown>>
  </hidden>|<\hidden>
    <tit|Adjoining \Palgebraic\Q elements to <math|\<Gamma\>>>

    <\render-theorem|Lemma ALG-VAL>
      <\compressed>
        Let <math|\<gamma\>\<in\>d<rsup|-1>*\<Gamma\>> be such that
        <math|\<Delta\>\<assign\>\<Gamma\>+\<gamma\>*<value|ZZ>=\<Gamma\>\<cup\>\<Gamma\>+\<gamma\>\<cup\>\<cdots\>\<cup\>\<Gamma\>+<around*|(|d-1|)>*\<gamma\>\<varsupsetneq\>\<Gamma\>>
        for <math|d\<gtr\>1>. Let <math|\<xi\>\<in\>K> be such that
        <math|v<around*|(|\<xi\>|)>=d*\<gamma\>> and
        <math|\<mu\>\<assign\>Y<rsup|d>-\<xi\>\<in\>K<around*|[|Y|]>>. Let
        <math|L\<assign\>K<around*|[|Y|]>/<around*|(|\<mu\>|)>> and
        <math|y=Y+<around*|(|\<mu\>|)>>. Then <math|L\<supseteq\>K> is a
        valued field extension for the valuation defined by

        <\equation*>
          v<around*|(|P<around*|(|y|)>|)>\<assign\>min
          <around*|(|v<around*|(|P<rsub|0>|)>,\<ldots\>,v<around*|(|P<rsub|p-1>|)>+<around*|(|d-1|)>*\<gamma\>|)>,<space|2em><text|for
          all <math|<around*|\<nobracket\>|P\<in\>K<around*|[|Y|]><rsub|d><rsup|\<neq\>0>|\<nobracket\>>>.>
        </equation*>

        Moreover, if <math|F\<supseteq\>K> is a valued field extension and
        <math|a\<in\>F> satisfies <math|a<rsup|d>=\<xi\>>, then there exists
        a<nbsp>unique valued field embedding
        <math|\<varphi\>:L\<rightarrow\>F> over <math|K> with
        <hgroup|<math|\<varphi\><around*|(|a|)>=y>>.
      </compressed>
    </render-theorem>

    <vspace*|0.5fn><strong|Exercise. >We also have
    <math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>.

    <vspace*|0.25fn><strong|Proof.> Similar to the previous proof
    (exercise).<htab|5mm><qed>
  </hidden>|<\hidden>
    <tit|Algebraic closure of valued fields>

    <\theorem*>
      If <math|char K=char \<b-k\>=0>, then the valuation on <math|K> can be
      extended to the algebraic closure <math|K<rsup|\<up-a\>>> of <math|K>.
      Any valued field embedding <math|K\<rightarrow\>F> into another
      algebraically closed field <math|F> extends to a valued field embedding
      <math|K<rsup|\<up-a\>>\<rightarrow\>F>.
    </theorem*>

    \;

    <strong|Proof.> Lemmas ALG-IMM, ALG-RES, ALG-VAL, and Zorn yield:

    <\itemize>
      <item>An algebraic valued field extension <math|L\<supseteq\>K>, such
      that

      <\compact>
        <\itemize>
          <item><math|L> is henselian (ALG-IMM).

          <item><math|\<b-k\><rsub|L>> algebraically closed (ALG-RES).

          <item><math|\<Gamma\><rsub|L>> is divisible (ALG-VAL).
        </itemize>
      </compact>

      <item>Any valued field embedding <math|K\<rightarrow\>F> extends to a
      valued field embedding <math|K<rsup|\<up-a\>>\<rightarrow\>F>. (See
      also below.)
    </itemize>

    Newton polygon methods <math|\<Longrightarrow\>> <math|L> is
    algebraically closed.<htab|5mm><qed>
  </hidden>|<\hidden>
    <tit|Basic model theoretic terminology>

    <unroll|<\shown>
      <paragraph|Languages>

      Triples <math|\<cal-L\>=<around*|(|S,\<cal-L\><rsup|\<up-r\>>,\<cal-L\><rsup|\<up-f\>>|)>>
      of <strong|sorts> (<abbr|e.g.> <math|<around*|{|K,\<Gamma\>|}>>),
      <strong|relations>, and <strong|functions>.
    </shown>|<\shown>
      <paragraph|<math|\<cal-L\>>-structures>

      <\compact>
        <math|\<b-M\>=<around*|(|<around*|(|M<rsub|s>|)><rsub|s\<in\>S>,<around*|(|R<rsub|i>|)>,<around*|(|f<rsub|j>|)>|)>>,
        sets <math|M<rsub|s>>, relations <math|R<rsub|i>\<subseteq\>M<rsub|s<rsub|1>>\<times\>\<cdots\>\<times\>M<rsub|s<rsub|n>>>,

        functions <math|f<rsub|j>:M<rsub|s<rsub|1>>\<times\>\<cdots\>\<times\>M<rsub|s<rsub|n>>\<rightarrow\>M<rsub|t>>
        (<math|s<rsub|1>,\<ldots\>,s<rsub|n>,t> depend on <math|i>,
        <math|j>). Morphisms, <text-dots>
      </compact>
    </shown>|<\shown>
      <paragraph|<math|\<cal-L\>>-formulas>

      <\compact>
        Formed from <math|\<cal-L\>>, variables of the sorts <math|S>, and
        <math|\<top\>>, <math|\<bot\>>, <math|\<neg\>>, <math|\<vee\>>,
        <math|\<wedge\>>, <math|=>, <math|\<exists\>>, <math|\<forall\>>.

        <math|\<cal-L\><rsub|A>> \<assign\> extension of <math|\<cal-L\>>
        with constants <math|a\<in\>A<rsub|s>> of sort <math|s> for
        <math|A=<around*|(|A<rsub|s>|)><rsub|s\<in\>S>>
      </compact>
    </shown>|<\shown>
      <paragraph|<math|\<cal-L\>>-theories>

      Let <math|\<b-M\>> be an <math|\<cal-L\>>-structure and
      <math|\<Sigma\>>, <math|\<Sigma\><rprime|'>> sets of
      <math|\<cal-L\>>-formulas

      <\wide-tabular>
        <tformat|<cwith|1|-1|4|4|cell-hpart|1>|<cwith|1|-1|7|7|cell-hpart|1>|<table|<row|<\cell>
          <space|1em>
        </cell>|<\cell>
          <math|\<b-M\>\<vDash\>\<Sigma\>>
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <math|\<b-M\>> is a model for <math|\<Sigma\>>
        </cell>|<\cell>
          <math|\<Sigma\>\<vDash\>\<Sigma\><rprime|'>>
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <math|\<b-M\>\<vDash\>\<Tau\>> whenever
          <math|\<b-M\>\<vDash\>\<Sigma\><rprime|'>>
        </cell>>|<row|<\cell>
          \;
        </cell>|<\cell>
          <math|Th<around*|(|\<b-M\>|)>>
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <math|<around*|{|\<sigma\>\<suchthat\>\<b-M\>\<vDash\>\<sigma\>|}>>
        </cell>|<\cell>
          <math|Th<around*|(|\<Sigma\>|)>>
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <math|<around*|{|\<sigma\>\<suchthat\>\<Sigma\>\<vDash\>\<sigma\>|}>>
        </cell>>>>
      </wide-tabular>
    </shown>>
  </hidden>|<\hidden>
    <tit|Basic concepts from model theory>

    <unroll|<\shown>
      <math|\<cal-L\>> : a fixed a language<vspace|0.2fn>
    </shown>|<\shown>
      <\wide-tabular>
        <tformat|<cwith|1|-1|5|5|cell-hpart|1>|<table|<row|<\cell>
          <math|\<b-M\>\<equiv\>\<b-N\>>
        </cell>|<\cell>
          <space|1.2spc>
        </cell>|<\cell>
          <math|Th<around*|(|\<b-M\>|)>=Th<around*|(|\<b-N\>|)>>
        </cell>|<\cell>
          <space|1.2spc>
        </cell>|<\cell>
          <math|\<b-M\>> and <math|\<b-N\>> are <strong|elementary
          equivalent>
        </cell>>|<row|<\cell>
          <math|\<b-M\>\<preccurlyeq\>\<b-N\>>
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <math|\<b-M\>\<subseteq\>\<b-N\>> and
          <math|\<b-M\>\<equiv\><rsub|\<cal-L\><rsub|M>>\<b-N\>>
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <math|\<b-M\>> is an <strong|elementary substructure> of
          <math|\<b-N\>>
        </cell>>>>
      </wide-tabular>
    </shown>|<\shown>
      <\surround|<vspace*|0.25fn>|<vspace|0.25fn>>
        <\wide-tabular>
          <tformat|<table|<row|<\cell>
            <math|\<Sigma\>> is <strong|complete>
          </cell>|<\cell>
            <math|\<Sigma\>> has a model and
            <math|\<Sigma\>\<vDash\>\<sigma\>> or
            <math|\<Sigma\>\<vDash\>\<neg\>\<sigma\>> for any formula
            <math|\<sigma\>>
          </cell>>|<row|<\cell>
            <math|T> is an <math|\<cal-L\>>-<strong|theory>
          </cell>|<\cell>
            <math|Th<around*|(|T|)>=T>
          </cell>>|<row|<\cell>
            <math|\<Sigma\>> <strong|axiomatizes> <math|T>
          </cell>|<\cell>
            <math|Th<around*|(|\<Sigma\>|)>=T>
          </cell>>>>
        </wide-tabular>
      </surround>
    </shown>|<\shown>
      <switch|<\hidden>
        <\wide-tabular>
          <tformat|<table|<row|<\cell>
            <strong|qf-formula>
          </cell>|<\cell>
            Formula that does not involve <math|\<forall\>> or
            <math|\<exists\>>
          </cell>>|<row|<\cell>
            <math|\<varphi\><around*|(|x|)>> is <strong|\<Sigma\>-equivalent>
            to <math|\<psi\><around*|(|x|)>>
          </cell>|<\cell>
            <math|<around*|\<nobracket\>|\<Sigma\>\<vDash\>\<varphi\><around*|(|x|)>|\<nobracket\>><space|0.6spc>\<Longleftrightarrow\><space|0.6spc><around*|\<nobracket\>|\<Sigma\>\<vDash\>\<psi\><around*|(|x|)>|\<nobracket\>>>
          </cell>>|<row|<\cell>
            <math|\<Sigma\>> has <strong|quantifier elimination>
          </cell>|<\cell>
            Any formula is <math|\<Sigma\>>-equivalent to a qf-formula
          </cell>>|<row|<\cell>
            <space|14.2em>
          </cell>|<\cell>
            <phantom|Any formula is <math|\<Sigma\>>-equivalent to an
            <math|\<exists\>>-formula>
          </cell>>>>
        </wide-tabular>
      </hidden>|<\hidden>
        <\wide-tabular>
          <tformat|<table|<row|<\cell>
            <strong|qf-formula>
          </cell>|<\cell>
            Formula that does not involve <math|\<forall\>> or
            <math|\<exists\>>
          </cell>>|<row|<\cell>
            <strong|\<exists\>-formula>
          </cell>|<\cell>
            Formula <math|<around*|(|\<exists\>x|)><space|0.6spc>\<varphi\><around*|(|x|)>>
            for some qf-formula <math|\<varphi\><around*|(|x|)>>
          </cell>>|<row|<\cell>
            <math|\<varphi\><around*|(|x|)>> is <strong|\<Sigma\>-equivalent>
            to <math|\<psi\><around*|(|x|)>>
          </cell>|<\cell>
            <math|<around*|\<nobracket\>|\<Sigma\>\<vDash\>\<varphi\><around*|(|x|)>|\<nobracket\>><space|0.6spc>\<Longleftrightarrow\><space|0.6spc><around*|\<nobracket\>|\<Sigma\>\<vDash\>\<psi\><around*|(|x|)>|\<nobracket\>>>
          </cell>>|<row|<\cell>
            <math|\<Sigma\>> has <strong|quantifier elimination>
          </cell>|<\cell>
            Any formula is <math|\<Sigma\>>-equivalent to a qf-formula
          </cell>>|<row|<\cell>
            <math|\<Sigma\>> is <strong|model complete>
          </cell>|<\cell>
            Any formula is <math|\<Sigma\>>-equivalent to an
            <math|\<exists\>>-formula
          </cell>>|<row|<\cell>
            <space|14.2em>
          </cell>|<\cell>
            \;
          </cell>>>>
        </wide-tabular>
      </hidden>|<\shown>
        <\wide-tabular>
          <tformat|<table|<row|<\cell>
            <strong|qf-formula>
          </cell>|<\cell>
            Formula that does not involve <math|\<forall\>> or
            <math|\<exists\>>
          </cell>>|<row|<\cell>
            <strong|\<exists\>-formula>
          </cell>|<\cell>
            Formula <math|<around*|(|\<exists\>x|)><space|0.6spc>\<varphi\><around*|(|x|)>>
            for some qf-formula <math|\<varphi\><around*|(|x|)>>
          </cell>>|<row|<\cell>
            <math|\<varphi\><around*|(|x|)>> is <strong|\<Sigma\>-equivalent>
            to <math|\<psi\><around*|(|x|)>>
          </cell>|<\cell>
            <math|<around*|\<nobracket\>|\<Sigma\>\<vDash\>\<varphi\><around*|(|x|)>|\<nobracket\>><space|0.6spc>\<Longleftrightarrow\><space|0.6spc><around*|\<nobracket\>|\<Sigma\>\<vDash\>\<psi\><around*|(|x|)>|\<nobracket\>>>
          </cell>>|<row|<\cell>
            <math|\<Sigma\>> has <strong|quantifier elimination>
          </cell>|<\cell>
            Any formula is <math|\<Sigma\>>-equivalent to a qf-formula
          </cell>>|<row|<\cell>
            <math|\<Sigma\>> is <strong|model complete>
          </cell>|<\cell>
            Any formula is <math|\<Sigma\>>-equivalent to an
            <math|\<exists\>>-formula
          </cell>>|<row|<\cell>
            <math|T<rsup|\<ast\>>> is a <strong|model companion> of <math|T>
          </cell>|<\cell>
            <math|T<rsup|\<ast\>>> model complete and
          </cell>>|<row|<\cell>
            <space|14.2em>
          </cell>|<\cell>
            Any model of <math|T> embeds into a model of
            <math|T<rsup|\<ast\>>>
          </cell>>>>
        </wide-tabular>
      </shown>>
    </shown>>
  </hidden>|<\hidden>
    <tit|Types and saturation>

    <unroll|<\shown>
      <\compact>
        Let <math|\<Phi\>=\<Phi\><around*|(|x|)>> be a set of formulas
        depending on free variables <math|x=<around*|(|x<rsub|i>|)>> of sorts
        <math|<around*|(|s<rsub|i>|)>>

        Let <math|\<b-M\>> be an <math|\<cal-L\>>-structure and
        <math|M<rsub|x>\<assign\><big|prod><rsub|i>M<rsub|s<rsub|i>>>.
      </compact>
    </shown>|<\shown>
      <switch|<\hidden>
        <\wide-tabular>
          <tformat|<cwith|3|3|2|2|cell-bsep|2spc>|<cwith|4|4|2|2|cell-bsep|2spc>|<table|<row|<\cell>
            <math|a\<in\>M<rsub|x>> <strong|realizes> <math|\<Phi\>> in
            <math|\<b-M\>>
          </cell>|<\cell>
            <math|M\<vDash\>\<varphi\><around*|(|a|)>> for all
            <math|\<varphi\>\<in\>\<Phi\>>
          </cell>>|<row|<\cell>
            <math|\<Phi\>> is <strong|realized> in <math|\<b-M\>>
          </cell>|<\cell>
            <math|a> realizes <math|\<Phi\>> in <math|M> for some
            <math|a\<in\>M<rsub|x>>
          </cell>>|<row|<\cell>
            <math|\<Phi\>> is <math|><strong|\<Sigma\>-realizable>
          </cell>|<\cell>
            <math|\<Phi\>> is realized in some model <math|\<b-M\>> of
            <math|\<Sigma\>>
          </cell>>|<row|<\cell>
            \;
          </cell>|<\cell>
            <phantom|<math|\<Phi\>> is a <math|Th<around*|(|\<b-M\><rsub|A>|)>>-realizable
            <math|x>-type for the language <math|\<cal-L\><rsub|A>>>
          </cell>>>>
        </wide-tabular>
      </hidden>|<\hidden>
        <\wide-tabular>
          <tformat|<cwith|3|3|2|2|cell-bsep|2spc>|<cwith|6|6|2|2|cell-bsep|2spc>|<table|<row|<\cell>
            <math|a\<in\>M<rsub|x>> <strong|realizes> <math|\<Phi\>> in
            <math|\<b-M\>>
          </cell>|<\cell>
            <math|M\<vDash\>\<varphi\><around*|(|a|)>> for all
            <math|\<varphi\>\<in\>\<Phi\>>
          </cell>>|<row|<\cell>
            <math|\<Phi\>> is <strong|realized> in <math|\<b-M\>>
          </cell>|<\cell>
            <math|a> realizes <math|\<Phi\>> in <math|M> for some
            <math|a\<in\>M<rsub|x>>
          </cell>>|<row|<\cell>
            <math|\<Phi\>> is <math|><strong|\<Sigma\>-realizable>
          </cell>|<\cell>
            <math|\<Phi\>> is realized in some model <math|\<b-M\>> of
            <math|\<Sigma\>>
          </cell>>|<row|<\cell>
            <math|\<Phi\>> is an <strong|<em|x>-type>
          </cell>|<\cell>
            <math|\<Phi\>> is realized in some <math|\<b-M\>>
          </cell>>|<row|<\cell>
            <space|0.75em>\V<space|0.75em>that is <strong|complete>
          </cell>|<\cell>
            either <math|\<varphi\>\<in\>\<Phi\>> or
            <math|<around*|\<nobracket\>|\<neg\>\<varphi\>|\<nobracket\>>\<in\>\<Phi\>>
            for all <math|\<varphi\><around*|(|x|)>>
          </cell>>|<row|<\cell>
            <math|><space|0.75em>\V<space|0.75em><strong|over>
            <math|A\<subseteq\>M> in <math|\<b-M\>>
          </cell>|<\cell>
            <math|\<Phi\>> is a <math|Th<around*|(|\<b-M\><rsub|A>|)>>-realizable
            <math|x>-type for the language <math|\<cal-L\><rsub|A>>
          </cell>>>>
        </wide-tabular>
      </hidden>|<\shown>
        <\wide-tabular>
          <tformat|<cwith|3|3|2|2|cell-bsep|2spc>|<cwith|6|6|2|2|cell-bsep|2spc>|<cwith|8|8|1|-1|cell-bsep|0spc>|<cwith|8|8|1|-1|cell-vcorrect|t>|<table|<row|<\cell>
            <math|a\<in\>M<rsub|x>> <strong|realizes> <math|\<Phi\>> in
            <math|\<b-M\>>
          </cell>|<\cell>
            <math|M\<vDash\>\<varphi\><around*|(|a|)>> for all
            <math|\<varphi\>\<in\>\<Phi\>>
          </cell>>|<row|<\cell>
            <math|\<Phi\>> is <strong|realized> in <math|\<b-M\>>
          </cell>|<\cell>
            <math|a> realizes <math|\<Phi\>> in <math|M> for some
            <math|a\<in\>M<rsub|x>>
          </cell>>|<row|<\cell>
            <math|\<Phi\>> is <math|><strong|\<Sigma\>-realizable>
          </cell>|<\cell>
            <math|\<Phi\>> is realized in some model <math|\<b-M\>> of
            <math|\<Sigma\>>
          </cell>>|<row|<\cell>
            <math|\<Phi\>> is an <strong|<em|x>-type>
          </cell>|<\cell>
            <math|\<Phi\>> is realized in some <math|\<b-M\>>
          </cell>>|<row|<\cell>
            <space|0.75em>\V<space|0.75em>that is <strong|complete>
          </cell>|<\cell>
            either <math|\<varphi\>\<in\>\<Phi\>> or
            <math|<around*|\<nobracket\>|\<neg\>\<varphi\>|\<nobracket\>>\<in\>\<Phi\>>
            for all <math|\<varphi\><around*|(|x|)>>
          </cell>>|<row|<\cell>
            <math|><space|0.75em>\V<space|0.75em><strong|over>
            <math|A\<subseteq\>M> in <math|\<b-M\>>
          </cell>|<\cell>
            <math|\<Phi\>> is a <math|Th<around*|(|\<b-M\><rsub|A>|)>>-realizable
            <math|x>-type for the language <math|\<cal-L\><rsub|A>>
          </cell>>|<row|<\cell>
            <math|\<b-M\>> is <strong|<em|\<kappa\>>-saturated>
          </cell>|<\cell>
            For any <math|A\<subseteq\>M> of size <math|\<less\>\<kappa\>>
            and any variable <math|v> of <math|\<cal-L\>>,
          </cell>>|<row|<\cell>
            \;
          </cell>|<\cell>
            each complete <math|v>-type over <math|A> in <math|\<b-M\>> is
            realized in <math|\<b-M\>>
          </cell>>>>
        </wide-tabular>
      </shown>>
    </shown>|<\shown>
      <\render-theorem|<smash-bottom|Proposition>>
        <\compact>
          Suppose that <math|\<b-M\>> is <math|\<kappa\>>-saturated,
          <math|\<kappa\>> is infinite, <math|A\<subseteq\>M> and <math|x>
          have size <math|\<less\>\<kappa\>>.

          Then every <math|x>-type over <math|A> in <math|\<b-M\>> is
          realized in <math|\<b-M\>>.
        </compact>
      </render-theorem>
    </shown>>
  </hidden>|<\hidden>
    <tit|Quantifier elimination and completeness>

    <unroll|<\shown>
      <\theorem*>
        Assume that <math|\<Sigma\>> eliminates quantifiers and also has a
        model.

        Then <math|\<Sigma\>> is complete if and only if some
        <math|\<cal-L\>>-structure embeds into every model of
        <math|\<Sigma\>>.
      </theorem*>
    </shown>|<\shown>
      \;

      <strong|Note:> The <math|\<cal-L\>>-structure does not need to be a
      model of <math|\<Sigma\>>.<vspace|1fn>
    </shown>|<\shown>
      <strong|Example.>

      <\itemize>
        <unroll|<\shown>
          <item>The theory ACF of algebraically closed fields has QE. (See
          below)
        </shown>|<\shown>
          <item>So does the theory ACF(0) of algebraically closed fields of
          characteristic zero.
        </shown>|<\shown>
          <item><math|<value|ZZ>> embeds into any (algebraically closed)
          field of characteristic zero.
        </shown>|<\shown>
          <item>Hence ACF(0) is complete.
        </shown>>
      </itemize>
    </shown>>
  </hidden>|<\hidden>
    <tit|Test for quantifier-elimination>

    <\theorem*>
      Let <math|\<Sigma\>> be given and suppose that

      <\wide-tabular>
        <tformat|<cwith|1|1|1|1|cell-hpart|1>|<cwith|1|1|5|5|cell-hpart|1>|<table|<row|<\cell>
          \;
        </cell>|<\cell>
          \<forall\><tabular|<tformat|<cwith|1|1|1|1|cell-hyphen|t>|<twith|table-valign|c>|<table|<row|<\cell>
            <\itemize>
              <item><math|\<b-M\>\<vDash\>\<Sigma\>>

              <item>proper substructure <math|\<b-A\>\<varsubsetneq\>\<b-M\>>

              <item><math|<around*|\||A|\|><rsup|+>>-saturated model
              <math|\<b-N\>> of <math|\<Sigma\>>

              <item>embedding <math|\<iota\>:\<b-A\>\<longhookrightarrow\>\<b-N\>>
            </itemize>
          </cell>>>>>
        </cell>|<\cell>
          <space|1em>
        </cell>|<\cell>
          \<exists\><tabular|<tformat|<cwith|1|1|1|1|cell-hyphen|t>|<twith|table-valign|c>|<table|<row|<\cell>
            <\itemize>
              <item><math|b\<in\>M<rsub|s>\<setminus\>A<rsub|s>> for some
              <math|s\<in\>S>

              <item>an extension <math|<wide|\<iota\>|^>:\<b-A\><around*|\<langle\>|b|\<rangle\>>\<longhookrightarrow\>\<b-N\>>
              of <math|\<iota\>>
            </itemize>
          </cell>>>>>
        </cell>|<\cell>
          \;
        </cell>>>>
      </wide-tabular>

      Then <math|\<Sigma\>> admits quantifier elimination.
    </theorem*>

    \;

    <with|gr-mode|<tuple|group-edit|edit-props>|gr-frame|<tuple|scale|1cm|<tuple|0.5gw|0.639996gh>>|gr-geometry|<tuple|geometry|1par|0.156503par|center>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|2|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-grid-aspect|<tuple|<tuple|axes|#e0e0ff>|<tuple|1|#e0e0ff>|<tuple|2|#e0e0ff>>|gr-grid-aspect-props|<tuple|<tuple|axes|#e0e0ff>|<tuple|1|#e0e0ff>|<tuple|2|#e0e0ff>>|gr-text-at-halign|center|gr-arrow-end|\<gtr\>|gr-dash-style|11100|<graphics||<with|text-at-valign|center|text-at-repulse|1spc|text-at-halign|center|<math-at|\<b-A\><around*|\<langle\>|b|\<rangle\>>|<point|0.0|0.5>>>|<with|text-at-halign|center|text-at-repulse|1spc|text-at-valign|center|<math-at|\<b-A\>|<point|0|-1>>>|<with|text-at-halign|center|text-at-repulse|1spc|text-at-valign|center|<math-at|\<b-M\>|<point|-1.5|0.5>>>|<with|text-at-halign|center|text-at-repulse|1spc|text-at-valign|center|<math-at|\<b-N\>|<point|1.5|0.5>>>|<with|arrow-end|\<gtr\>|text-at-halign|center|text-at-valign|center|<line|<point|0|-1>|<point|-1.5|0.5>>>|<with|arrow-end|\<gtr\>|text-at-halign|center|text-at-valign|center|<line|<point|0|-1>|<point|1.5|0.5>>>|<with|arrow-end|\<gtr\>|dash-style|10|<line|<point|0.0|0.5>|<point|1.49999586588945|0.499995865889454>>>|<with|arrow-end|\<gtr\>|dash-style|10|<line|<point|0.0|0.5>|<point|-1.5|0.5>>>|<with|arrow-end|\<gtr\>|dash-style|10|<line|<point|0|-1>|<point|0.0|0.5>>>>>
  </hidden>|<\hidden>
    <tit|Test for model completeness>

    <\theorem*>
      Let <math|\<Sigma\>> be given and suppose that

      <\wide-tabular>
        <tformat|<cwith|1|1|1|1|cell-hpart|1>|<cwith|1|1|5|5|cell-hpart|1>|<table|<row|<\cell>
          \;
        </cell>|<\cell>
          \<forall\><tabular|<tformat|<cwith|1|1|1|1|cell-hyphen|t>|<twith|table-valign|c>|<table|<row|<\cell>
            <\itemize>
              <item><math|\<b-M\>\<vDash\>\<Sigma\>>

              <item><math|\<b-A\>\<vDash\>\<Sigma\>> with
              <math|\<b-A\>\<subseteq\>\<b-M\>>

              <item><math|<around*|\||A|\|><rsup|+>>-saturated
              <math|\<b-N\>\<succcurlyeq\>\<b-A\>>

              <item>inclusion <math|\<iota\>:\<b-A\>\<longhookrightarrow\>\<b-N\>>
            </itemize>
          </cell>>>>>
        </cell>|<\cell>
          <space|1em>
        </cell>|<\cell>
          \<exists\> an embedding <math|<wide|\<iota\>|^>:\<b-M\>\<longhookrightarrow\>\<b-N\>>
          that extends <math|\<iota\>>
        </cell>|<\cell>
          \;
        </cell>>>>
      </wide-tabular>

      Then <math|\<Sigma\>> is model complete.
    </theorem*>

    <with|gr-mode|<tuple|group-edit|edit-props>|gr-frame|<tuple|scale|1cm|<tuple|0.5gw|0.639996gh>>|gr-geometry|<tuple|geometry|1par|0.156503par|center>|gr-grid|<tuple|empty>|gr-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-edit-grid-aspect|<tuple|<tuple|axes|none>|<tuple|1|none>|<tuple|2|none>>|gr-edit-grid|<tuple|empty>|gr-edit-grid-old|<tuple|cartesian|<point|0|0>|1>|gr-grid-aspect|<tuple|<tuple|axes|#e0e0ff>|<tuple|1|#e0e0ff>|<tuple|2|#e0e0ff>>|gr-grid-aspect-props|<tuple|<tuple|axes|#e0e0ff>|<tuple|1|#e0e0ff>|<tuple|2|#e0e0ff>>|gr-text-at-halign|center|gr-arrow-end|\<gtr\>|gr-dash-style|11100|<graphics||<with|text-at-halign|center|text-at-repulse|1spc|text-at-valign|center|<math-at|\<b-A\>|<point|0|-1>>>|<with|text-at-halign|center|text-at-repulse|1spc|text-at-valign|center|<math-at|\<b-M\>|<point|-1.5|0.5>>>|<with|text-at-halign|center|text-at-repulse|1spc|text-at-valign|center|<math-at|\<b-N\>|<point|1.5|0.5>>>|<with|arrow-end|\<gtr\>|text-at-halign|center|text-at-valign|center|<line|<point|0|-1>|<point|-1.5|0.5>>>|<with|arrow-end|\<gtr\>|text-at-halign|center|text-at-valign|center|<line|<point|0|-1>|<point|1.5|0.5>>>|<with|arrow-end|\<gtr\>|dash-style|10|<line|<point|-1.5|0.499996>|<point|1.5|0.5>>>>>
  </hidden>|<\hidden>
    <tit|Application to ACF>

    <\compressed>
      <unroll|<\shown>
        <\theorem*>
          The theory ACF of algebraically closed fields (for
          <math|\<cal-L\>=<around*|{|0,1,+,-,\<cdot\>|}>>) has QE.
        </theorem*>
      </shown>|<\shown>
        <vspace*|0.5fn><strong|Proof.> Let

        <\itemize>
          <item><math|E> be an algebraically closed field.

          <item><math|A\<subseteq\>E> a substructure, <abbr|i.e.> an integral
          domain.

          <item><math|F> an algebraically closed field that is
          <math|<around*|\||A|\|><rsup|+>>-saturated.

          <item>An embedding <math|\<iota\>:A\<rightarrow\>F>.
        </itemize>
      </shown>|<\shown>
        Problem: construct <math|a\<in\>E\<setminus\>A> + embedding
        <math|<wide|\<iota\>|^>:A<around*|[|a|]>\<rightarrow\>F> that extends
        <math|\<iota\>>.<vspace|0.5fn>
      </shown>|<\shown>
        <switch|<\hidden>
          <strong|Case 0. <em|A> is not a field>

          <unroll|<\shown>
            Take <math|x\<in\>A<rsup|\<neq\>0>> such that
            <math|a\<assign\>x<rsup|-1>\<in\>E\<setminus\>A>.
          </shown>|<\shown>
            Then <math|\<iota\>> uniquely extends into an embedding
            <math|<wide|\<iota\>|^>:<around*|\<nobracket\>|A<around*|[|a|]>=A*x<rsup|-<value|NN>>|\<nobracket\>>\<rightarrow\>F>
            with <math|<wide|\<iota\>|^><around*|(|a|)>=\<iota\><around*|(|x|)><rsup|-1>>.
          </shown>>
        </hidden>|<\hidden>
          <strong|Case 1. <em|K><space|0.6spc>\<assign\><space|0.6spc><em|A>
          is a field that is not algebraically closed>

          <unroll|<\shown>
            Take <math|a\<in\>K<rsup|\<up-a\>>\<setminus\>K\<subseteq\>E\<setminus\>K>
            with <math|P<around*|(|a|)>=0> for some irreductible
            <math|<smash|\<mu\>=\<mu\><rsub|d>*Y<rsup|d>+\<cdots\>+\<mu\><rsub|0>\<in\>K<around*|[|Y|]>>>.
          </shown>|<\shown>
            Since <math|F> is algebraically closed, there exists a
            <math|b\<in\>F> with <math|\<iota\><around*|(|\<mu\><rsub|d>|)>*b<rsup|d>+\<cdots\>+\<iota\><around*|(|\<mu\><rsub|0>|)>=0>.
          </shown>|<\shown>
            Since <math|K<around*|[|Y|]>/<around*|(|\<mu\>|)>\<cong\>\<iota\><around*|(|K|)><around*|(|b|)>>,
            we may extend <math|\<iota\>> into an embedding
            <math|<wide|\<iota\>|^>:K<around*|(|a|)>\<rightarrow\>F> with
            <math|<wide|\<iota\>|^><around*|(|a|)>=b>.
          </shown>>
        </hidden>|<\shown>
          <strong|Case 2. <em|K><space|0.6spc>\<assign\><space|0.6spc><em|A>
          is an algebraically closed field>

          <unroll|<\shown>
            Let <math|a\<in\>E\<setminus\>K>. Then <math|a> is transcendental
            over <math|K>.
          </shown>|<\shown>
            Saturation <math|\<Longrightarrow\>> There exists a
            transcendental <math|b\<in\>F\<setminus\>K>.
          </shown>|<\shown>
            Then <math|K<around*|[|a|]>\<cong\>\<iota\><around*|(|K|)><around*|[|b|]>>,
            so we may extend <math|\<iota\>> into an embedding
            <math|<wide|\<iota\>|^>:K<around*|[|a|]>\<rightarrow\>F>.<htab|5mm><qed>
          </shown>>
        </shown>>
      </shown>>
    </compressed>
  </hidden>|<\hidden>
    <tit|Application to ACVF>

    <\theorem*>
      The theory ACVF of algebraically closed valued fields eliminates
      quantifiers.
    </theorem*>

    <\compact>
      <vspace*|0.5fn><strong|Note. >ACVF can be modeled in the language
      <math|<around*|(|K,\<Gamma\>,+,-,\<cdot\>,v,\<leqslant\><rsub|\<Gamma\>>,+<rsub|\<Gamma\>>,-<rsub|\<Gamma\>>|)>>.

      Sometimes: extra sort for <math|\<b-k\>> (and extra component
      <math|\<iota\><rsub|\<b-k\>>:\<b-k\><rsub|A>\<rightarrow\>\<b-k\><rsub|F>>).

      Alternatively: one-sorted language <math|<around*|(|K,+,-,\<cdot\>,\<preccurlyeq\>|)>>.<vspace|0.333fn>
    </compact>

    <strong|Proof. >Let

    <\compressed>
      <\itemize>
        <item><math|E> be an algebraically closed valued field.

        <item><math|A\<subseteq\>E> a substructure, <abbr|i.e.> a \Pvalued
        integral domain\Q.

        <item><math|F> an algebraically closed valued field that is
        <math|<around*|\||A|\|><rsup|+>>-saturated.

        <item>An embedding <math|\<iota\>:A\<rightarrow\>F>.
      </itemize>
    </compressed>

    Problem: construct <math|y\<in\>E\<setminus\>A> + embedding
    <math|<wide|\<iota\>|^>:A<around*|[|y|]>\<rightarrow\>F> that extends
    <math|\<iota\>>.<vspace|0.3333fn>

    To easy notations, we may assume wlog that <math|A\<subseteq\>F> and that
    <math|\<iota\>> is the inclusion.

    \;
  </hidden>|<\hidden>
    <tit|Proof that ACVF has QE \V continued>

    <strong|Case 0. <em|A> is not a field>

    <\compressed>
      Let <math|x> be a non-invertible element of <math|A<rsup|\<neq\>0>> and
      take <math|y\<assign\>x<rsup|-1>>.

      Let <math|<wide|\<iota\>|^>:<around*|\<nobracket\>|A<around*|[|a|]>=A*x<rsup|-<value|NN>>|\<nobracket\>>\<rightarrow\>F>
      extend <math|\<iota\>> with <math|<wide|\<iota\>|^><around*|(|a|)>=\<iota\><around*|(|x|)><rsup|-1>>
      (as for ACF).

      Any element of <math|A<around*|[|a|]>> is of the form
      <math|c*a<rsup|n>=c*x<rsup|-n>> for <math|c\<in\>A> and
      <math|n\<in\><value|NN>>.

      Then <math|v<around*|(|<wide|\<iota\>|^><around*|(|c*a<rsup|n>|)>|)>=v<around*|(|c*x<rsup|-n>|)>=v<around*|(|c|)>-n*v<around*|(|x|)>>,
      both in <math|\<Gamma\><rsub|A<around*|[|a|]>>=\<Gamma\><rsub|A>> and
      in <math|\<Gamma\><rsub|F>\<supseteq\>\<Gamma\><rsub|A>>.

      Hence the embedding <math|<wide|\<iota\>|^>> preserves the
      valuation.<vspace|0.5fn>
    </compressed>

    <strong|Case 1a. <em|K> \<assign\> <em|A> is a field, but <em|k<rsub|K>>
    is not AC (algebraically closed).>

    <\compressed>
      Let <math|\<mu\>\<in\>K<around*|[|Y|]>> be monic with
      <math|\<mu\>\<preccurlyeq\>1> and <math|<wide|\<mu\>|\<bar\>>>
      irreducible in<nbsp><math|\<b-k\><rsub|K><around*|[|Y|]>>. Let
      <math|y\<in\>E> be a root of <math|\<mu\>>.

      Since <math|F> is AC, <math|\<exists\>> <math|a\<in\>F> with
      <math|\<mu\><around*|(|a|)>=0>. Let
      <math|<wide|\<iota\>|^>:K<around*|[|y|]>\<rightarrow\>F> extend
      <math|\<iota\>> with <math|<wide|\<iota\>|^><around*|(|y|)>=a> (as for
      ACF).

      Then <math|\<b-k\><rsub|K><around*|(|<wide|a|\<bar\>>|)>\<cong\>\<b-k\><rsub|K><around*|(|<wide|y|\<bar\>>|)>>
      and <math|<wide|\<iota\>|^>> preserves the valuation by Lemma
      ALG-RES.<vspace|0.5fn>
    </compressed>

    <strong|Case 1b. <em|K> \<assign\> <em|A> is a field, but
    \<Gamma\><em|<rsub|K>> is not divisible.>

    Similar as above, with <math|\<mu\>=Y<rsup|p>-\<xi\>> for <math|p> prime
    and <math|\<xi\>\<in\>K> such that <math|p<rsup|-1>*v<around*|(|\<xi\>|)>\<nin\>\<Gamma\><rsub|K>>.
  </hidden>|<\hidden>
    <tit|Completeness>

    The valued field <math|K> has <strong|characteristic>
    <math|<around*|(|m,n|)>> if <math|char K=m> and <math|char
    \<b-k\><rsub|K>=n>.<vspace|0.5fn>

    <\theorem*>
      The theory <math|ACV<rsub|<around*|(|m,n|)>>> of algebraically valued
      fields of characteristic<nbsp><math|<around*|(|m,n|)>> has QE and
      it<nbsp>is<nbsp>complete.
    </theorem*>

    <vspace*|0.5fn><strong|QE. >The characteristic of a valued field is
    conserved under the extensions.

    Hence the previous proof goes through for any fixed
    characteristic.<vspace|0.5fn>

    <strong|Completeness. >Sufficient: a valued ring that embeds into any
    model of <math|ACV<rsub|<around*|(|m,n|)>>>.

    <\itemize>
      <item>If <math|m=n=0>, then we may take <math|<value|ZZ>> with the
      trivial valuation.

      <item>If <math|m=0> and <math|n=p> is prime, then we may take
      <math|<value|ZZ>> with the <math|p>-adic valuation.

      <item>If <math|m=n=p> is prime, then we may take
      <math|<value|FF><rsub|p>> with the trivial valuation.<htab|5mm><qed>
    </itemize>
  </hidden>|<\hidden>
    <tit|Valued ordered fields>

    Let <math|<around*|(|K,\<leqslant\>|)>> be an ordered field (so
    <math|<value|QQ>\<subseteq\>K>).

    Given <math|X\<subseteq\>K>, its <strong|convex hull> is
    <math|<around*|{|a\<in\>K\<suchthat\><around*|(|\<exists\><around*|\<nobracket\>|x,y|\<nobracket\>>\<in\>X|)><space|1.2spc>x\<leqslant\>a\<leqslant\>y|}>>.<vspace|0.5fn>

    <\definition*>
      Given a valuation <math|v> on <math|K>, we say that
      <math|<around*|(|K,\<leqslant\>,v|)>> is an <strong|ordered valued
      field> if <math|<O><rsub|K>> is convex.
    </definition*>

    <vspace*|0.5fn><strong|Example. >The \Pfinest\Q valuation <math|v> with
    <math|<O><rsub|K>=hull<around*|(|K|)>> and
    <math|<o><rsub|K>=<around*|{|a\<in\>K\<suchthat\><around*|\||a|\|>\<less\><value|QQ><rsup|\<gtr\>0>|}>>.<vspace|0.5fn>

    <\theorem*>
      The theory RCVF of real closed valued fields eliminates quantifiers and
      is complete.
    </theorem*>

    <vspace*|0.5fn><strong|Proof. >QE: similar as for ACVF. Completeness:
    <math|<value|ZZ>> embeds into any model.<htab|5mm><qed>
  </hidden>>
</body>

<\initial>
  <\collection>
    <associate|eqn-long-above|<macro|0fn>>
    <associate|eqn-long-below|<macro|0fn>>
    <associate|eqn-short-above|<macro|0fn>>
    <associate|eqn-short-below|<macro|0fn>>
    <associate|font|cal=termes,TeX Gyre Pagella>
    <associate|font-base-size|9>
    <associate|font-family|rm>
    <associate|info-flag|minimal>
    <associate|magnification|2>
    <associate|math-font|math-pagella>
    <associate|page-bot|-5mm>
    <associate|page-height|auto>
    <associate|page-medium|beamer>
    <associate|page-type|16:9>
    <associate|page-width|auto>
    <associate|par-par-sep|0.25fn>
    <associate|strong-color|dark magenta>
    <associate|title-shadow-font-color|dark red>
    <associate|title-sunny-font-color|#a66>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|auto-1|<tuple|1|?>>
    <associate|auto-2|<tuple|2|?>>
    <associate|auto-3|<tuple|3|?>>
    <associate|auto-4|<tuple|4|?>>
    <associate|auto-5|<tuple|5|?>>
    <associate|auto-6|<tuple|6|?>>
    <associate|auto-7|<tuple|7|?>>
    <associate|auto-8|<tuple|8|?>>
    <associate|auto-9|<tuple|9|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|toc>
      <with|par-left|<quote|4tab>|Ordered fields.
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-1><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Hausdorff fields.
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-2><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Well-based series.
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|<with|color|<quote|#483030>|font-family|<quote|rm>|<with|mode|<quote|math>|p>>-adic
      numbers. <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-4><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Examples:
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-5><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Languages
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-6><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|<with|color|<quote|#483030>|font-family|<quote|rm>|<with|mode|<quote|math>|\<cal-L\>>>-structures
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-7><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|<with|color|<quote|#483030>|font-family|<quote|rm>|<with|mode|<quote|math>|\<cal-L\>>>-formulas
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-8><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|<with|color|<quote|#483030>|font-family|<quote|rm>|<with|mode|<quote|math>|\<cal-L\>>>-theories
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-9><vspace|0.15fn>>
    </associate>
  </collection>
</auxiliary>