<TeXmacs|2.1.2>

<style|ims>

<\body>
  <\hide-preamble>
    \;
  </hide-preamble>

  <screens|<shown|<\with-screen-color|<pattern|singapore-bright.jpg|100%|100%>>
    \;

    <\with|par-mode|center>
      <tabular*|<tformat|<cwith|1|3|1|1|cell-bsep|2.5spc>|<cwith|3|3|1|1|cell-tsep|3spc>|<table|<row|<cell|<with|font-base-size|15|strong-sunny-font-color|pastel
      orange|<strong|<with|color|orange|Lesson 9 \V
      <space|-0.2spc>H-fields>>>>>|<row|<cell|<with|strong-sunny-font-color|pastel
      orange|<strong|<with|color|#c06000|Joris van der
      Hoeven>>>>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|>>|<row|<cell|<wide-tabular|<tformat|<table|<row|<\cell>
        <htab|5mm><with|strong-sunny-font-color|pastel
        brown|<strong|<with|color|brown|IMS summer school>>>
      </cell>>>>>>>|<row|<cell|<wide-tabular|<tformat|<table|<row|<\cell>
        <htab|5mm><with|strong-sunny-font-color|pastel
        brown|<strong|<with|color|brown|Singapore, July 14, 2023>>>
      </cell>>>>>>>>>>
    </with>
  </with-screen-color>>|<\hidden>
    <tit|Differential fields>

    <unroll|<\shown>
      <\definition*>
        A <strong|differential field> is a field <math|K> with a
        <strong|derivation> <math|\<partial\>:K\<rightarrow\>K> such that,
        for all <math|a,b\<in\>R>,

        <\description>
          <item*|D1><math|<hgroup|\<partial\><around*|(|a+b|)>>=\<partial\>
          a+\<partial\> b>.

          <item*|D2><math|\<partial\><around*|(|a*b|)>=<around*|(|\<partial\>
          a|)>*b+a*<around*|(|\<partial\> b|)>>.
        </description>

        We often write <math|a<rprime|'>\<assign\>\<partial\> a>. The set
        <math|C=C<rsub|K>\<assign\><around*|{|<hgroup|c\<in\>K>\<suchthat\>\<partial\>
        c=0|}>> is a field: the field of <strong|constants>.
      </definition*>
    </shown>|<\shown>
      <vspace*|0.5fn><strong|Note. >The set <math|Der<around*|(|K|)>> of
      derivations on a field <math|K> forms a <math|K>-vector
      space.<vspace|0.5fn>
    </shown>|<\shown>
      <\compact>
        <strong|Reparameterization, change of derivation, compositional
        conjugation. >

        Let <math|K> be a differential ring and
        <math|\<varphi\>\<in\>K<rsup|\<neq\>0>>.

        Then <math|\<up-delta\>\<assign\>\<phi\><rsup|-1>*\<partial\>> is
        again a derivation on <math|K>.

        We write <math|K<rsup|\<phi\>>> for the differential field <math|K>
        but with <math|\<up-delta\>> as the derivation.<vspace|0.5fn>
      </compact>
    </shown>|<\shown>
      <strong|Example. ><math|<value|TT>> with
      <math|\<up-delta\>\<assign\>x*\<partial\>> is isomorphic to
      <math|<value|TT>\<circ\>exp> with <math|\<partial\>>.
    </shown>>
  </hidden>|<\hidden>
    <tit|H-fields>

    <unroll|<\shown>
      <\definition*>
        An <strong|H-field> is an ordered valued field <math|K> with a
        derivation such that

        <\description>
          <item*|H1><math|y\<gtr\>C<rsub|K>\<Longrightarrow\>y<rprime|'>\<gtr\>0>,
          for <math|y\<in\>K>.

          <item*|H2><math|<O><rsub|K>=C<rsub|K>+<o><rsub|K>>.
        </description>
      </definition*>
    </shown>|<\shown>
      <vspace*|0.5fn><strong|Note. >For <math|f,g\<in\>K> with
      <math|g\<nasymp\>1>, these axioms imply
      <math|f\<prec\>g\<Rightarrow\>f<rprime|'>\<prec\>g<rprime|'>> and
      <math|f\<preccurlyeq\>g\<Rightarrow\>f<rprime|'>\<preccurlyeq\>g<rprime|'>>.<vspace|0.5fn>
    </shown>|<\shown>
      <\definition*>
        We say that the derivation on <math|K> is <strong|small> if
        <math|\<varepsilon\>\<prec\>1\<Longrightarrow\>\<varepsilon\><rprime|'>\<prec\>1>
        for any <math|\<varepsilon\>\<prec\>1>.
      </definition*>
    </shown>|<\shown>
      <vspace*|0.5fn><strong|Note. >The set
      <math|Der<rsub|\<prec\>><around*|(|K|)>> of small derivations on
      <math|K> forms a <math|<O><rsub|K>>-module.
    </shown>>
  </hidden>|<\hidden>
    <tit|Examples>

    <unroll|<\shown>
      <paragraph|Hardy fields.>

      <\itemize>
        <unroll|<\shown>
          <item>Any Hardy field <math|K\<supseteq\><value|RR>> is an H-field.
        </shown>|<\shown>
          <item>More generally: any Hardy field with
          <math|b\<in\>K<rsup|\<preccurlyeq\>1>\<Rightarrow\>lim
          b\<in\>K>.<vspace|0.5fn>
        </shown>>
      </itemize>
    </shown>|<\shown>
      <paragraph|Transseries.>

      <\itemize>
        <unroll|<\shown>
          <item>The field <math|<value|TT>> of grid-based transseries is an
          H-field.
        </shown>|<\shown>
          <item>The field <math|<value|EE>> of exponential grid-based
          transseries is an H-field.
        </shown>|<\shown>
          <item>Given a \P<math|\<partial\>>-compatible\Q support type
          <math|\<cal-S\>>,

          the field <math|<value|TT><rsub|\<cal-S\>>> of
          <math|\<cal-S\>>-based transseries of finite logarithmic depth is
          an H-field.
        </shown>|<\shown>
          <item>Let <math|<value|TT><rsub|0><rsup|wb>\<assign\><value|LL><rsup|wb>\<assign\><value|R><around*|[|<around*|[|\<frak-L\>|]>|]>>
          and <math|<value|TT><rsub|1><rsup|wb>\<assign\><value|R><around*|[|<around*|[|<value|LL><rsup|wb><rsub|\<succ\>>|]>|]>>.

          Then <math|<value|TT><rsub|1><rsup|wb>> is an H-field. It contains
          <math|\<matheuler\>\<assign\><frac|1|x*log x*log<rsub|2>
          x*\<cdots\>>>.<vspace|0.5fn>
        </shown>>
      </itemize>
    </shown>|<\shown>
      <strong|Note. >For each of the above examples, the derivation is small.
    </shown>>
  </hidden>|<\hidden>
    <tit|Real closure>

    <unroll|<\shown>
      <\theorem*>
        The real closure of any H-field <math|K> is again an H-field. If
        <math|\<partial\><rsub|K>> is small, then so is
        <math|\<partial\><rsub|K<rsup|rc>>>.
      </theorem*>
    </shown>|<\shown>
      <\compressed>
        <unroll|<\shown>
          <strong|Proof. >Given an H-field <math|K>, we already know that
          <math|K<rsup|rc>> is a real closed valued field.
        </shown>|<\shown>
          Let <math|P=P<rsub|d>*Y<rsup|d>+\<cdots\>+P<rsub|0>\<in\>K<around*|[|Y|]>>,
          <math|y\<in\>K<rsup|rc>> with <math|P<around*|(|y|)>=0>, and
          <math|\<partial\> P\<assign\><around*|(|\<partial\>
          P<rsub|d>|)>*Y<rsup|d>+\<cdots\>+\<partial\> P<rsub|0>>.
        </shown>|<\shown>
          We must have <math|y<rprime|'>\<assign\>-<around*|(|\<partial\>
          P|)><around*|(|y|)>/P<rprime|'><around*|(|y|)>>. This defines a
          derivation on <math|K<rsup|rc>>.
        </shown>|<\shown>
          Note that <math|C<rsub|K<rsup|rc>>=C<rsup|rc>>.<vspace|0.3333fn>
        </shown>>
      </compressed>
    </shown>|<\shown>
      <\compressed>
        <strong|H1. >If <math|y\<in\><around*|(|K<rsup|rc>|)><rsup|\<gtr\>C>>,
        then <math|y<rsup|n>\<sim\>u\<in\>K<rsup|\<gtr\>C>> for some
        <math|n\<geqslant\>1>.

        Then <math|<around*|(|y<rsup|n>|)><rprime|'>\<sim\>u<rprime|'>>,
        whence <math|y<rprime|'>\<sim\>y*u<rprime|\<dag\>>/n\<gtr\>0>.<vspace|0.3333fn>
      </compressed>
    </shown>|<\shown>
      <\compressed>
        <strong|H2. >Let <math|y\<in\>K<rsup|rc>> with
        <math|y\<preccurlyeq\>1>.

        Then <math|P<around*|(|y|)>=0> for some <math|P\<assign\>D+E> with
        <math|D\<in\>C<around*|[|Y|]><rsup|\<neq\>0>> and
        <math|E\<in\>K<around*|[|Y|]><rsup|\<prec\>1>>.

        Since <math|D<around*|(|y|)>\<prec\>1> and <math|D> splits over
        <math|C<rsup|rc>=C<rsub|K<rsup|rc>>>, we have <math|y\<sim\>c> for
        some <math|c\<in\>C<rsub|K<rsup|rc>>>.<vspace|0.3333fn>
      </compressed>
    </shown>|<\shown>
      <strong|Preservation of smallness. >Exercise.<htab|5mm><qed>
    </shown>>
  </hidden>|<\hidden>
    <tit|Gaps>

    <unroll|<\shown>
      <\proposition*>
        <\compact>
          There is a unique map <math|\<nosymbol\><rprime|\<dag\>>:\<Gamma\><rsup|\<neq\>0>\<rightarrow\>\<Gamma\>>
          with <math|v<around*|(|a|)><rprime|\<dag\>>=v<around*|(|a<rprime|\<dag\>>|)>>
          for all <math|a\<in\>K<rsup|\<nasymp\>1>>.

          We also define <math|\<alpha\><rprime|'>\<assign\>\<alpha\>+\<alpha\><rprime|\<dag\>>>
          for all <math|\<alpha\>\<in\>\<Gamma\><rsup|\<neq\>0>>.
        </compact>
      </proposition*>
    </shown>|<\shown>
      <\proposition*>
        <\compressed>
          Exactly one of the following situations occurs:

          <\enumerate>
            <item><math|<around*|(|\<Gamma\><rsup|\<neq\>0>|)><rprime|\<dag\>>>
            has a largest element (we say that <math|K> is
            <strong|grounded>).

            <item><math|\<Gamma\>=<around*|(|\<Gamma\><rsup|\<neq\>0>|)><rprime|'>>
            (we say that <math|K> has <strong|asymptotic integration>).

            <item><math|\<Gamma\>=<around*|(|\<Gamma\><rsup|\<neq\>0>|)><rprime|\<dag\>>\<cup\><around*|{|\<beta\>|}>\<cup\><around*|(|\<Gamma\><rsup|\<gtr\>0>|)><rprime|'>>
            with <math|<around*|(|\<Gamma\><rsup|\<neq\>0>|)><rprime|\<dag\>>\<less\>\<beta\>\<less\><around*|(|\<Gamma\><rsup|\<gtr\>0>|)><rprime|'>>
            (we say that <math|K> has a <strong|gap>)
          </enumerate>
        </compressed>
      </proposition*>
    </shown>|<\shown>
      <\compressed>
        <\enumerate>
          <unroll|<\shown>
            <item>Example: <math|<value|EE>>, the exponential transseries,
            <math|max <around*|(|\<Gamma\><rsub|<value|EE>><rsup|\<neq\>0>|)><rprime|\<dag\>>=v<around*|(|x<rsup|-1>|)>>.
          </shown>|<\shown>
            <item>Example: <math|<value|TT>>, since any transseries can even
            be integrated.
          </shown>|<\shown>
            <item>Example: <math|<value|TT><rsup|wb><rsub|1>>, with
            <math|\<beta\>\<assign\>v<around*|(|\<matheuler\>|)>>,
            <math|\<matheuler\>\<assign\><frac|1|x*log x*log<rsub|2>
            x*\<cdots\>>>. We have <math|\<varepsilon\><rprime|'>\<prec\>\<matheuler\>\<prec\>\<delta\><rprime|\<dag\>>>
            for any <math|\<varepsilon\>,\<delta\>\<prec\>1>.
          </shown>>
        </enumerate>
      </compressed>
    </shown>>
  </hidden>|<\hidden>
    <tit|Gaps \V continued>

    <\compressed>
      <unroll|<\shown>
        Consider a formal solution <math|L<rsub|\<omega\>>> of

        <\equation*>
          L<rsub|\<omega\>><around*|(|log
          x|)>=L<rsub|\<omega\>><around*|(|x|)>-1.
        </equation*>
      </shown>|<\shown>
        <switch|<\hidden>
          We have <math|L<rsub|\<omega\>>\<succ\>1>, but
          <math|L<rsub|\<omega\>>\<prec\>log<rsub|l> x> for all
          <math|l\<in\><value|NN>>.
        </hidden>|<\shown>
          We have <math|L<rsub|\<omega\>>\<succ\>1>, but
          <math|L<rsub|\<omega\>>\<prec\>log<rsub|l> x> for all
          <math|l\<in\><value|NN>>. Hence,

          <\equation*>
            L<rsub|\<omega\>>\<nin\><value|TT><rsup|wb><rsub|\<alpha\>>,<space|2em><text|for
            any ordinal <math|\<alpha\>>.>
          </equation*>
        </shown>>
      </shown>|<\shown>
        However,

        <\equation*>
          <frac|L<rsub|\<omega\>><rprime|'><around*|(|log
          x|)>|x>=L<rprime|'><rsub|\<omega\>><around*|(|x|)>,
        </equation*>
      </shown>|<\shown>
        so

        <\equation*>
          L<rprime|'><rsub|\<omega\>><around*|(|x|)>=<frac|1|x*log
          x*log<rsub|2> x*\<cdots\>>=\<matheuler\>\<subseteq\><value|TT><rsub|1><rsup|wb>\<setminus\><value|TT><rsub|0><rsup|wb>.
        </equation*>
      </shown>|<\shown>
        Furthermore, <math|<value|TT><rsub|0><rsup|wb>> has asymptotic
        integration (whence no gap), but

        <\equation*>
          \<up-lambda\>\<assign\>-\<up-gamma\><rprime|\<dag\>>=<frac|1|x>+<frac|1|x*log
          x>+<frac|1|x*log x*log<rsub|2> x>+\<cdots\>\<in\><value|TT><rsub|0><rsup|wb>.
        </equation*>
      </shown>>
    </compressed>

    \;
  </hidden>|<\hidden>
    <tit|Adjoining new logarithms>

    <unroll|<\shown>
      <\compressed>
        <unroll|<\shown>
          Let <math|K> be an <math|H>-field with divisible
          <math|\<Gamma\>\<assign\>\<Gamma\><rsub|K>> and let
          <math|C\<assign\>C<rsub|K>>.
        </shown>|<\shown>
          Assume that <math|K> is grounded and let
          <math|\<ell\>\<in\>K<rsup|\<succ\>1,\<gtr\>0>> be such that
          <math|v<around*|(|\<ell\><rprime|\<dag\>>|)>> is maximal.
        </shown>|<\shown>
          Then <math|\<up-delta\>\<assign\><around*|(|\<ell\><rprime|\<dag\>>|)><rsup|-1>*\<partial\>>
          is a small derivation and <math|Der<rsub|\<prec\>><around*|(|K|)>=\<cal-O\><rsub|K>*\<up-delta\>>.<vspace|0.5fn>
        </shown>>
      </compressed>
    </shown>|<\shown>
      <\lemma*>
        Let <math|L\<assign\>K<around*|(|y|)>> with
        <math|y<rprime|'>=\<ell\><rprime|\<dag\>>>. There is a unique
        ordering on <math|L> with <math|y\<gtr\>0> for which
        <math|L\<supseteq\>K> is an extension of H-fields. We have
        <math|C<rsub|L>=C>, <math|\<Gamma\><rsub|L>=\<Gamma\>\<oplus\><value|ZZ>*v<around*|(|y|)>>,
        <math|\<Gamma\><rsup|\<less\>0>\<less\><value|ZZ><rsup|\<gtr\>0>*v<around*|(|y|)>>,
        <math|<around*|(|\<Gamma\><rsub|L><rsup|\<neq\>0>|)><rprime|\<dag\>>\<leqslant\>v<around*|(|y<rprime|\<dag\>>|)>>.

        Moreover, if <math|F\<supseteq\>K> is another H-field extension and
        <math|a\<in\>F<rsup|\<gtr\>0>> satisfies
        <math|a<rprime|'>=\<ell\><rprime|\<dag\>>>, then there exists a
        unique embedding of H-fields <math|\<varphi\>:L\<rightarrow\>F> with
        <math|\<varphi\><around*|(|y|)>=a>.
      </lemma*>
    </shown>|<\shown>
      <strong|Example. ><math|K=<value|EE>> with <math|\<ell\>=x>. Then
      <math|y<rprime|'>=\<ell\><rprime|\<dag\>>=<frac|1|x>>, so
      <math|y\<in\>log x+C>, <abbr|e.g.> <math|y=log x>.
    </shown>>
  </hidden>|<\hidden>
    <tit|Adjoining new logarithms>

    <unroll|<\shown>
      <\lemma*>
        Let <math|L\<assign\>K<around*|(|y|)>> with
        <math|y<rprime|'>=\<ell\><rprime|\<dag\>>>. There is a unique
        ordering on <math|L> with <math|y\<gtr\>0> for which
        <math|L\<supseteq\>K> is an extension of H-fields. We have
        <math|C<rsub|L>=C>, <math|\<Gamma\><rsub|L>=\<Gamma\>\<oplus\><value|ZZ>*v<around*|(|y|)>>,
        <math|\<Gamma\><rsup|\<less\>0>\<less\><value|ZZ><rsup|\<gtr\>0>*v<around*|(|y|)>\<less\>0>,
        <math|<around*|(|\<Gamma\><rsub|L><rsup|\<neq\>0>|)><rprime|\<dag\>>\<leqslant\>v<around*|(|y<rprime|\<dag\>>|)>>.

        Moreover, if <math|F\<supseteq\>K> is another H-field extension and
        <math|a\<in\>F<rsup|\<gtr\>0>> satisfies
        <math|a<rprime|'>=\<ell\><rprime|\<dag\>>>, then there exists a
        unique embedding of H-fields <math|\<varphi\>:L\<rightarrow\>F> with
        <math|\<varphi\><around*|(|y|)>=a>.
      </lemma*>
    </shown>|<\shown>
      <strong|Proof. >We may assume wlog that
      <math|\<partial\>=\<up-delta\>>, whence
      <math|\<ell\><rprime|\<dag\>>=1> and
      <math|v<around*|(|a<rprime|\<dag\>>|)>\<leqslant\>0> for all
      <math|a\<in\>K<rsup|\<nasymp\>1>>.
    </shown>|<\shown>
      Since <math|y<rprime|\<dag\>>=\<ell\><rsup|-1>\<prec\>1>, we have
      <math|<value|ZZ>*v<around*|(|y|)>\<cap\>\<Gamma\>=\<varnothing\>>, so
      <math|\<beta\>\<assign\>v<around*|(|y|)>> lies in a cut over
      <math|\<Gamma\>>.
    </shown>|<\shown>
      By Lemma<nbsp>TR-VAL from Lesson 8, <math|L> has a unique valuation
      with <math|\<Gamma\><rsub|L>=\<Gamma\>\<oplus\><value|ZZ>*\<beta\>> and
      <math|v<around*|(|y|)>=\<beta\>>. Moreover,
      <math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>, and for any valued field
      extension <math|F\<supseteq\>K> and <math|a\<in\>F<rsup|\<neq\>0>> with
      <math|v<around*|(|a|)>> in the same cut as <math|\<beta\>> over
      <math|K>, there exists a unique valued field embedding
      <math|\<varphi\>:L\<rightarrow\>F> with
      <math|\<varphi\><around*|(|y|)>=a>.<vspace|0.5fn>
    </shown>|<\shown>
      <strong|To do. >Verify that <math|v> comes from an ordering that
      satisfies <strong|H1> and <strong|H2>.
    </shown>>
  </hidden>|<\hidden>
    <tit|Adjoining new logarithms \V continued proof>

    <unroll|<\shown>
      Given <math|f\<in\>K<around*|(|y|)><rsup|\<neq\>0>>, there exist
      <math|u\<in\>K<rsup|\<neq\>0>> and <math|n\<in\><value|ZZ>> with
      <math|v<around*|(|f|)>=v<around*|(|u|)>+n*\<beta\>>, whence
      <hgroup|<math|f\<sim\>u*y<rsup|n>>>.
    </shown>|<\shown>
      We must have <math|f\<gtr\>0\<Longleftrightarrow\>u\<gtr\>0> and one
      verifies that this makes <math|L> an ordered field.
    </shown>|<\shown>
      <strong|H2. >If <math|v<around*|(|f|)>=0>, then <math|n=0> and
      <math|v<around*|(|u|)>=0>, so <math|u\<in\>C+<o>> and
      <math|f\<in\>C+<o><rsub|L>>.<vspace|0.25fn>
    </shown>|<\shown>
      <\compact>
        <unroll|<\shown>
          <strong|H1. >Verify first that <math|f\<gtr\>C\<Longrightarrow\>f<rprime|'>\<gtr\>0>
          for <math|f\<in\>K<rsup|\<neq\>0>*y<rsup|<value|ZZ>>>.
        </shown>|<\shown>
          Also verify that <math|f\<prec\>g\<Rightarrow\>f<rprime|'>\<prec\>g<rprime|'>>
          for <math|f,g\<in\>K<rsup|\<neq\>0>*y<rsup|<value|ZZ>>> with
          <math|g\<nasymp\>1>.
        </shown>|<\shown>
          Now consider <math|P,Q\<in\>K<around*|[|Y|]>> with
          <math|P/Q\<gtr\>0> and <math|P\<succ\>Q>.
        </shown>|<\shown>
          For certain <math|i,j>, we then have
          <math|P<around*|(|y|)>\<sim\>P<rsub|i>*y<rsup|i>>,
          <math|Q<around*|(|y|)>\<sim\>Q<rsub|j>*y<rsup|j>>,
          <math|P<around*|(|y|)><rprime|'>\<sim\><around*|(|P<rsub|i>*y<rsup|i>|)><rprime|'>>,
          <math|Q<around*|(|y|)><rprime|'>\<sim\><around*|(|Q<rsub|i>*y<rsup|j>|)><rprime|'>>.
        </shown>|<\shown>
          Now <math|<around*|(|P/Q|)><rprime|'>\<gtr\>0\<Leftrightarrow\>P<around*|(|y|)><rprime|\<dag\>>\<gtr\>Q<around*|(|y|)><rprime|\<dag\>>\<Leftrightarrow\><around*|(|P<rsub|i>*y<rsup|i>|)><rprime|\<dag\>>\<gtr\><around*|(|Q<rsub|j>*y<rsup|j>|)><rprime|\<dag\>>\<Longleftarrow\><around*|(|<around*|(|P<rsub|i>/Q<rsub|j>|)>*y<rsup|i-j>|)><rprime|\<dag\>>\<gtr\>0>.<vspace|0.5fn>
        </shown>>
      </compact>
    </shown>|<\shown>
      <\compact>
        <unroll|<\shown>
          <strong|Embedding property. >We already have the valued field
          embedding <math|\<varphi\>> with
          <hgroup|<math|\<varphi\><around*|(|y|)>=a>>.
        </shown>|<\shown>
          Since <math|y<rprime|'>=a<rprime|'>=\<ell\><rprime|\<dag\>>>, this
          embedding preserves <math|\<partial\>>.
        </shown>|<\shown>
          Given <math|f\<in\>K<around*|(|y|)><rsup|\<gtr\>0>>, we have
          <math|f\<sim\>u*y<rsup|n>\<gtr\>0> for
          <math|u\<in\>K<rsup|\<neq\>0>> and <math|n\<in\><value|NN>>.
        </shown>|<\shown>
          <math|\<varphi\>> preserves valuation <math|\<Rightarrow\>>
          <math|\<varphi\>> preserves <math|\<sim\>> <math|\<Rightarrow\>>
          <math|\<varphi\><around*|(|y|)>\<sim\>u*a<rsup|n>\<gtr\>0>.<htab|5mm><qed>
        </shown>>
      </compact>
    </shown>>
  </hidden>|<\hidden>
    <tit|Adjoining immediate integrals>

    <unroll|<\shown>
      <\compact>
        Let <math|K> be a real closed <math|H>-field with
        <math|\<Gamma\>\<assign\>\<Gamma\><rsub|K>> and let
        <math|C\<assign\>C<rsub|K>>.

        Assume that <math|K> has asymptotic integration.
      </compact>
    </shown>|<\shown>
      <\lemma*>
        Let <math|L\<assign\>K<around*|(|y|)>>, where
        <math|y<rprime|'>=g\<in\>K\<setminus\>\<partial\> K>. Then there
        exists a unique ordering on <math|L> with <math|y\<nasymp\>1>, for
        which <math|L\<supseteq\>K> is an extension of H-fields. This
        extension is immediate.

        Moreover, if <math|F\<supseteq\>K> is another H-field extension and
        <math|a\<in\>F> satisfies <math|a<rprime|'>=g>, then there exists a
        unique embedding of H-fields <math|\<varphi\>:L\<rightarrow\>F> with
        <math|\<varphi\><around*|(|y|)>=a>.
      </lemma*>
    </shown>|<\shown>
      <\compressed>
        <unroll|<\shown>
          <strong|Proof. >We construct a pc-sequence
          <math|<around*|(|y<rsub|\<rho\>>|)>> that approximates <math|y>:

          <\itemize>
            <item><math|y<rsub|0>\<assign\>0>.

            <item><math|y<rsub|\<rho\>+1>\<assign\>y<rsub|\<rho\>>+\<delta\>>,
            where <math|\<delta\><rprime|'>\<sim\>g-y<rsub|\<rho\>><rprime|'>>.

            <item><math|y<rsub|\<lambda\>>> \<assign\> a pseudo-limit of
            <math|<around*|(|y<rsub|\<rho\>>|)><rsub|\<rho\>\<less\>\<lambda\>>>
            if it exists.
          </itemize>
        </shown>|<\shown>
          <math|<around*|(|y<rsub|\<rho\>>|)>> is divergent of transcendental
          type (since <math|K> is real closed).
        </shown>|<\shown>
          Conclude by Lemma TR-IMM + \Proutine
          verifications\Q.<htab|5mm><qed>
        </shown>>
      </compressed>
    </shown>>
  </hidden>|<\hidden>
    <tit|A fork in the road>

    <unroll|<\shown>
      <\compressed>
        Let <math|K> be a real closed <math|H>-field with
        <math|\<Gamma\>\<assign\>\<Gamma\><rsub|K>> and let
        <math|C\<assign\>C<rsub|K>>.

        Assume that <math|\<up-gamma\>\<in\>K<rsup|\<gtr\>0>> with
        <math|<around*|(|\<Gamma\><rsup|\<neq\>0>|)><rprime|\<dag\>>\<less\>v<around*|(|\<matheuler\>|)>\<less\><around*|(|\<Gamma\><rsup|\<gtr\>0>|)><rprime|'>>.
      </compressed>
    </shown>|<\shown>
      <\lemma*>
        Let <math|\<epsilon\>\<in\><around*|{|1,-1|}>>.

        Let <math|L\<assign\>K<around*|(|y|)>> with
        <math|y<rprime|'>=\<up-gamma\>>. There is a unique ordering on
        <math|L> with <math|\<epsilon\>*y<rsup|\<epsilon\>>\<gtr\>C> for
        which <math|L\<supseteq\>K> is an extension of H-fields. We have
        <math|C<rsub|L>=C>, <math|\<Gamma\><rsub|L>=\<Gamma\>\<oplus\><value|ZZ>*v<around*|(|y|)>>,
        <math|\<Gamma\><rsup|\<less\>0>\<less\><value|ZZ>*v<around*|(|y|)>>,
        <math|<around*|(|\<Gamma\><rsub|L><rsup|\<neq\>0>|)><rprime|\<dag\>>\<leqslant\>v<around*|(|y<rprime|\<dag\>>|)>>.

        Moreover, if <math|F\<supseteq\>K> is another H-field extension and
        <math|a\<in\>F> satisfies <math|\<epsilon\>*a<rsup|\<epsilon\>>\<gtr\>C>
        and <math|a<rprime|'>=\<up-gamma\>>, then there exists a unique
        embedding of H-fields <math|\<varphi\>:L\<rightarrow\>F> with
        <math|\<varphi\><around*|(|y|)>=a>.
      </lemma*>
    </shown>|<\shown>
      <\compressed>
        <unroll|<\shown>
          <strong|Example. ><math|K=<value|TT><rsup|wb><rsub|1>>,
          <math|\<matheuler\>\<assign\><frac|1|x*log x*log<rsub|2>
          x*\<cdots\>>>.
        </shown>|<\shown>
          <\description>
            <unroll|<\shown>
              <item*|<math|\<epsilon\>=1>>In the \Pnatural\Q extension of
              <math|K> with <math|y<rsub|nat>=<value|I>\<up-gamma\>>, we have
              <math|y<rsub|nat>\<succ\>1>.
            </shown>|<\shown>
              <item*|<math|\<epsilon\>=-1>>Then
              <math|-y<rsub|nat><rsup|-1>\<prec\>1> satisfies
              <math|<around*|(|-y<rsub|nat><rsup|-1>|)><rprime|'>=\<up-gamma\>/y<rsub|nat><rsup|2>>.

              This \Pexplains\Q why we may also impose
              <math|<value|I>\<up-gamma\>\<prec\>1>.
            </shown>>
          </description>
        </shown>>
      </compressed>
    </shown>>
  </hidden>|<\hidden>
    <tit|Adjoining immediate exponentials>

    <unroll|<\shown>
      <\compressed>
        Let <math|K> be a real closed <math|H>-field with
        <math|\<Gamma\>\<assign\>\<Gamma\><rsub|K>> and let
        <math|C\<assign\>C<rsub|K>>.

        Assume that <math|K> has asymptotic integration.<vspace|0.5fn>
      </compressed>
    </shown>|<\shown>
      <\lemma*>
        Let <math|L\<assign\>K<around*|(|y|)>>, where
        <math|y<rprime|\<dag\>>=\<varepsilon\><rprime|'>\<in\>K\<setminus\><around*|(|K<rsup|\<neq\>>|)><rprime|\<dag\>>>
        for <math|\<varepsilon\>\<prec\>1>. Then there exists a unique
        ordering on<nbsp><math|L> with <math|y\<nasymp\>1>, for which
        <math|L\<supseteq\>K> is an extension of H-fields. This extension is
        immediate.

        Moreover, if <math|F\<supseteq\>K> is another H-field extension and
        <math|a\<in\>F> satisfies <math|a<rprime|\<dag\>>=\<varepsilon\><rprime|'>>,
        then there exists a unique embedding of H-fields
        <math|\<varphi\>:L\<rightarrow\>F> with
        <math|\<varphi\><around*|(|y|)>=a>.
      </lemma*>
    </shown>|<\shown>
      <\compressed>
        \;

        <strong|Proof. >Similar as for immediate integration. This time
        <math|<around*|(|y<rsub|\<rho\>>|)>> is as follows:

        <\itemize>
          <item><math|y<rsub|0>\<assign\>1>.

          <item><math|y<rsub|\<rho\>+1>\<assign\>y<rsub|\<rho\>>*<around*|(|1+\<delta\>|)>>,
          where <math|\<delta\><rprime|'>\<sim\>\<varepsilon\><rprime|'>-y<rsub|\<rho\>><rprime|\<dag\>>>.

          <item><math|y<rsub|\<lambda\>>> \<assign\> a pseudo-limit of
          <math|<around*|(|y<rsub|\<rho\>>|)><rsub|\<rho\>\<less\>\<lambda\>>>
          if it exists.<htab|5mm><qed>
        </itemize>
      </compressed>
    </shown>>
  </hidden>|<\hidden>
    <tit|Adjoining non-immediate exponential integrals>

    <unroll|<\shown>
      <\compact>
        <unroll|<\shown>
          Let <math|K> be an <math|H>-field and let
          <math|\<Gamma\>\<assign\>\<Gamma\><rsub|K>>,
          <math|C\<assign\>C<rsub|K>>.
        </shown>|<\shown>
          For <math|f,g\<in\>K<rsup|\<neq\>0>>, we have

          <\equation*>
            f\<prec\>g<space|1.2spc>\<Longleftrightarrow\><space|1.2spc>f<rprime|\<dag\>>+<o><rsub|K><rprime|'>\<less\>g<rprime|\<dag\>>+<o><rsub|K><rprime|'>.
          </equation*>
        </shown>|<\shown>
          Hence,

          <\equation*>
            \<Gamma\>\<cong\><around*|(|K<rsup|\<neq\>0>|)><rprime|\<dag\>>/<op|\<approx\>>,<space|2em>f\<approx\>g\<Longleftrightarrow\>f-g\<in\><o><rsub|K><rprime|'>.
          </equation*>
        </shown>|<\shown>
          But there may be elements of <math|K/<op|\<approx\>>> that are not
          in <math|<around*|(|K<rsup|\<neq\>0>|)><rprime|\<dag\>>/<op|\<approx\>>>.
        </shown>>
      </compact>
    </shown>|<\shown>
      <\lemma*>
        Assume that <math|\<Gamma\>> is divisible. Let
        <math|s\<in\>K<rsup|\<neq\>0>> be such that
        <math|s-a<rprime|\<dag\>>\<succ\><o><rsub|K><rprime|'>> for all
        <math|a\<in\>K<rsup|\<neq\>0>>. Consider the differential field
        <math|L\<assign\>K<around*|(|y|)>> with <math|y<rprime|\<dag\>>=s>.

        There exists a unique ordering on <math|L> for which
        <math|L\<supseteq\>K> is an extension of H-fields with
        <math|y\<gtr\>0>. We have <math|\<b-k\><rsub|L>=\<b-k\><rsub|K>>,
        <math|\<Gamma\><rsub|L>=\<Gamma\>\<oplus\><value|ZZ>*v<around*|(|y|)>>,
        and <math|\<partial\><rsub|L>> is small whenever
        <math|\<partial\><rsub|K>> is small.

        Moreover, if <math|F\<supseteq\>K> is another H-field extension and
        <math|a\<in\>F<rsup|\<gtr\>0>> satisfies <math|a<rprime|\<dag\>>=s>,
        then there exists a unique embedding of H-fields
        <math|\<varphi\>:L\<rightarrow\>F> with
        <math|\<varphi\><around*|(|y|)>=a>.
      </lemma*>
    </shown>>
  </hidden>|<\hidden>
    <tit|Liouville closure>

    <unroll|<\shown>
      Let <math|K> be an <math|H>-field and let
      <math|\<Gamma\>\<assign\>\<Gamma\><rsub|K>>,
      <math|C\<assign\>C<rsub|K>>.<vspace|0.5fn>

      <\theorem*>
        For <math|I=<around*|{|1|}>> or <math|I=<around*|{|1,2|}>>, there
        exist Liouville closed H-fields <math|L<rsub|i>\<supseteq\>K>,
        <math|i\<in\>I> with the property that for any Liouville closed
        H-field <math|F\<supseteq\>K>, there exists a unique <math|i\<in\>I>
        for which <math|L<rsub|i>> embeds into <math|F> over <math|K>, and
        this embedding is unique. If <math|K> contains \Pno
        <math|\<up-lambda\>> element\Q, then <math|I=<around*|{|1|}>>.
      </theorem*>
    </shown>|<\shown>
      <\compressed>
        <unroll|<shown|<strong|Proof sketch. >Track the introduction of
        <math|\<up-lambda\>> and <math|\<up-gamma\>> during the extension
        process.>|<\shown>
          <\itemize>
            <unroll|<\shown>
              <item>We may only introduce <math|\<up-gamma\>> through
              exponential integration of <math|\<up-lambda\>>.
            </shown>|<\shown>
              <item>Extensions by <math|<big|int>\<up-gamma\>> are grounded
              and do not contain <math|\<up-lambda\>>.
            </shown>|<\shown>
              <item>We <em|cannot> introduce <math|\<up-lambda\>> through
              integration:

              <\equation*>
                \<up-lambda\><rprime|'>\<approx\><around*|(|<tfrac|1|x>+<tfrac|1|x*log
                x>+<tfrac|1|x*log x*log<rsub|2>
                x>+\<cdots\>|)><rprime|'>=-<tfrac|1|x<rsup|2>>-<tfrac|1|x<rsup|2>*log
                x>-<tfrac|1|x*log x*log<rsub|2>
                x>-\<cdots\>-<tfrac|1|x<rsup|2>*log<rsup|2>
                x>-\<cdots\>\<approx\><tfrac|-\<up-lambda\>|x>.
              </equation*>
            </shown>|<\shown>
              <item>Similarly, <math|\<up-lambda\>> cannot be introduced
              through exponentiation or real closure.<htab|5mm><qed>
            </shown>>
          </itemize>
        </shown>>
      </compressed>
    </shown>>
  </hidden>|<\hidden>
    <tit|The <math|\<up-omega\>>-cut>

    <\compressed>
      <unroll|<\shown>
        <\equation*>
          \<up-lambda\>=x<rprime|\<dag\>>+<around*|(|log
          x|)><rprime|\<dag\>>+<around*|(|log<rsub|2>
          x|)><rprime|\<dag\>>+\<cdots\>=<frac|1|x>+<frac|1|x*log
          x>+<frac|1|x*log x*log<rsub|2> x>+\<cdots\>
        </equation*>
      </shown>|<\shown>
        <\equation*>
          \<up-lambda\><rprime|'>=<big|sum><rsub|i\<in\><value|NN>><around*|(|<frac|1|x*log
          x*\<cdots\>*log<rsub|i> x>|)><rprime|'>=<big|sum><rsub|i\<in\><value|NN>><big|sum><rsub|j\<leqslant\>i><frac|-<around*|(|log<rsub|j>
          x|)><rprime|\<dag\>>|x*log x*\<cdots\>*log<rsub|i>
          x>=-<big|sum><rsub|i\<in\><value|NN>><big|sum><rsub|j\<leqslant\>i><around*|(|log<rsub|i>
          x|)><rprime|\<dag\>>*<around*|(|log<rsub|j> x|)><rprime|\<dag\>>
        </equation*>
      </shown>|<\shown>
        <\equation*>
          \<up-lambda\><rsup|2>=<big|sum><rsub|i\<in\><value|NN>><big|sum><rsub|j\<in\><value|NN>><around*|(|log<rsub|i>
          x|)><rprime|\<dag\>>*<around*|(|log<rsub|j> x|)><rprime|\<dag\>>
        </equation*>
      </shown>|<\shown>
        <\equation*>
          \<up-omega\>\<assign\>-2*\<up-lambda\><rprime|'>-\<up-lambda\><rsup|2>=<big|sum><rsub|i\<in\><value|NN>><around*|(|<around*|(|log<rsub|i>
          x|)><rprime|\<dag\>>|)><rsup|2>=<frac|1|x<rsup|2>>+<frac|1|x<rsup|2>*log<rsup|2>
          x>+<frac|1|x<rsup|2>*log<rsup|2> x*log<rsub|2><rsup|2> x>+\<cdots\>
        </equation*>
      </shown>|<\shown>
        <render-theorem|Theorem (calle, ADH)|For any
        <math|P\<in\><value|R><around*|{|Y|}>\<setminus\><value|R>>, the
        first <math|\<omega\>> terms of <math|\<alpha\>*P<around*|(|\<up-lambda\>|)>+\<beta\>>
        coincide with <math|\<up-lambda\>> or <math|\<up-omega\>>, for
        certain <hgroup|<math|\<alpha\>,\<beta\>\<in\><value|R><around*|(|x,log
        x,\<ldots\>,log<rsub|r> x|)>>>.>
      </shown>>
    </compressed>
  </hidden>|<\hidden>
    <tit|First order conditions>

    \;

    <\wide-tabular>
      <tformat|<cwith|1|-1|3|3|cell-hpart|1>|<cwith|1|6|1|-1|cell-bsep|2spc>|<table|<row|<\cell>
        property of <math|\<up-gamma\>>
      </cell>|<\cell>
        \;
      </cell>|<\cell>
        <math|<with|math-display|true|<around*|(|\<forall\><around*|\<nobracket\>|\<varepsilon\>\<prec\>1|\<nobracket\>>|)><space|1em>\<varepsilon\><rprime|'>\<prec\>\<up-gamma\>\<prec\>\<varepsilon\><rprime|\<dag\>>>>
      </cell>>|<row|<\cell>
        property of <math|\<up-lambda\>>
      </cell>|<\cell>
        \;
      </cell>|<\cell>
        <math|<with|math-display|true|<around*|(|\<forall\><around*|\<nobracket\>|\<varepsilon\>\<prec\>1|\<nobracket\>>|)><space|1em>\<up-lambda\>+\<varepsilon\><rprime|\<dag\>\<dag\>>\<prec\>\<varepsilon\><rprime|\<dag\>>>>
      </cell>>|<row|<\cell>
        property of <math|\<up-omega\>>
      </cell>|<\cell>
        \;
      </cell>|<\cell>
        <math|<with|math-display|true|<around*|(|\<forall\><around*|\<nobracket\>|\<varepsilon\>\<prec\>1|\<nobracket\>>|)><space|1em>\<up-omega\>-2*<around*|(|\<varepsilon\><rprime|\<dag\>\<dag\>>|)><rprime|'>+<around*|(|\<varepsilon\><rprime|\<dag\>\<dag\>>|)><rsup|2>\<prec\><around*|(|\<varepsilon\><rprime|\<dag\>>|)><rsup|2>>>
      </cell>>|<row|<\cell>
        \;
      </cell>|<\cell>
        <space|1em>
      </cell>|<\cell>
        \;
      </cell>>|<row|<\cell>
        <paragraph|<math|\<up-gamma\>>-freeness>
      </cell>|<\cell>
        \;
      </cell>|<\cell>
        <math|<with|math-display|true|<around*|(|\<forall\>s|)><space|1.2spc><around*|(|\<exists\><around*|\<nobracket\>|\<varepsilon\>\<prec\>1|\<nobracket\>>|)><space|1em><around*|\<nobracket\>|s<space|0.6spc>\<preccurlyeq\><space|0.6spc>\<varepsilon\><rprime|'>|\<nobracket\>>\<vee\><around*|\<nobracket\>|s<space|0.6spc>\<succcurlyeq\><space|0.6spc>\<varepsilon\><rprime|\<dag\>>|\<nobracket\>>>>
      </cell>>|<row|<\cell>
        <paragraph|<math|\<up-lambda\>>-freeness>
      </cell>|<\cell>
        \;
      </cell>|<\cell>
        <math|<with|math-display|true|<around*|(|\<forall\>s|)><space|1.2spc><around*|(|\<exists\><around*|\<nobracket\>|\<varepsilon\>\<prec\>1|\<nobracket\>>|)><space|1em>s+\<varepsilon\><rprime|\<dag\>\<dag\>>\<succcurlyeq\>\<varepsilon\><rprime|\<dag\>>>>
      </cell>>|<row|<\cell>
        <paragraph|<math|\<up-omega\>>-freeness>
      </cell>|<\cell>
        \;
      </cell>|<\cell>
        <math|<with|math-display|true|<around*|(|\<forall\>s|)><space|1.2spc><around*|(|\<exists\><around*|\<nobracket\>|\<varepsilon\>\<prec\>1|\<nobracket\>>|)><space|1em>s-2*<around*|(|\<varepsilon\><rprime|\<dag\>\<dag\>>|)><rprime|'>+<around*|(|\<varepsilon\><rprime|\<dag\>\<dag\>>|)><rsup|2>\<succcurlyeq\><around*|(|\<varepsilon\><rprime|\<dag\>>|)>>>
      </cell>>>>
    </wide-tabular>

    \;

    \;

    <center|<math|\<up-omega\>>-freeness<space|1em><math|\<Longrightarrow\>><space|1em><math|\<up-lambda\>>-freeness<space|1em><math|\<Longrightarrow\>><space|1em><math|\<up-gamma\>>-freeness>
  </hidden>|<\hidden>
    <tit|Differential Newton polygon method>

    We need to generalize:

    <\itemize>
      <item>Differential Newton polynomials.

      <item>Equalizers.

      <item>Resolution of quasi-linear differential equations.

      <item>Unravelling.
    </itemize>

    \;
  </hidden>|<\hidden>
    <tit|Compositional conjugation>

    <unroll|<\shown>
      Consider <math|\<up-delta\>\<assign\>\<phi\><rsup|-1>*\<partial\>> with
      <math|\<phi\>\<in\>K<rsup|\<gtr\>0>>.<vspace|0.5fn>
    </shown>|<\shown>
      Any <math|P\<in\>K<around*|{|Y|}>> can be rewritten as a polynomial
      <math|P<rsup|\<phi\>>\<in\>K<rsup|\<phi\>><around*|{|Y|}>=K<around*|[|Y,\<up-delta\>
      Y,\<up-delta\><rsup|2> Y,\<ldots\>|]>>:

      <\eqnarray*>
        <tformat|<table|<row|<cell|\<partial\>>|<cell|=>|<cell|\<phi\>*\<up-delta\>>>|<row|<cell|\<partial\><rsup|2>>|<cell|=>|<cell|\<phi\><rsup|2>*\<up-delta\><rsup|2>+\<phi\><rprime|'>*\<up-delta\>>>|<row|<cell|\<partial\><rsup|3>>|<cell|=>|<cell|\<phi\><rsup|3>*\<up-delta\><rsup|3>+3*\<phi\>*\<phi\><rprime|'>*\<up-delta\><rsup|2>+\<phi\><rprime|''>*\<up-delta\>>>|<row|<cell|>|<cell|\<vdots\>>|<cell|>>>>
      </eqnarray*>
    </shown>|<\shown>
      <vspace*|0.5fn>We call <math|P<rsup|\<phi\>>> the <strong|compositional
      conjugate> of <math|P> by <math|\<phi\>>.
    </shown>>
  </hidden>|<\hidden>
    <tit|Link with upward shifting>

    \;

    <\equation*>
      <tabular*|<tformat|<cwith|1|1|1|-1|cell-bsep|3spc>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|5|5|cell-halign|l>|<cwith|1|1|2|2|cell-halign|l>|<cwith|1|-1|1|1|cell-halign|l>|<table|<row|<cell|\<uparrow\>>|<cell|<space|2em>>|<cell|\<phi\>\<assign\><frac|1|x>>|<cell|<space|2em>>|<cell|\<partial\>=\<phi\>*\<up-delta\>>>|<row|<cell|\<uparrow\>\<uparrow\>>|<cell|>|<cell|\<psi\>\<assign\><frac|1|x*log
      x>>|<cell|>|<cell|\<partial\>=\<psi\>*\<up-theta\>>>>>>
    </equation*>

    \;

    \;

    <\equation*>
      <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|5|5|cell-halign|l>|<cwith|1|-1|7|7|cell-halign|l>|<cwith|3|3|5|5|cell-halign|l>|<cwith|3|3|7|7|cell-halign|l>|<cwith|1|2|1|-1|cell-bsep|2spc>|<table|<row|<cell|P>|<cell|=>|<cell|x*Y*Y<rprime|''>-<around*|(|Y<rprime|'>|)><rsup|2>>|<cell|<space|1em>>|<cell|P>|<cell|=>|<cell|x*Y<rprime|''>-<around*|(|Y<rprime|'>|)><rsup|2>>>|<row|<cell|P\<uparrow\>>|<cell|=>|<cell|<frac|Y*Y<rprime|''>-Y*Y<rprime|'>|\<mathe\><rsup|x>>-<frac|<around*|(|Y<rprime|'>|)><rsup|2>|\<mathe\><rsup|2*x>>>|<cell|>|<cell|P<rsup|\<phi\>>>|<cell|=>|<cell|<frac|Y*\<up-delta\><rsup|2>
      Y-Y*\<up-delta\> Y|x>-<frac|<around*|(|\<up-delta\>
      Y|)><rsup|2>|x<rsup|2>>>>|<row|<cell|P\<uparrow\>\<uparrow\>>|<cell|=>|<cell|<frac|Y*Y<rprime|''>-Y*Y<rprime|'>|\<mathe\><rsup|\<mathe\><rsup|x>+2*x>>-<frac|Y*Y<rprime|'>|\<mathe\><rsup|\<mathe\><rsup|x>+x>>-<frac|<around*|(|Y<rprime|'>|)><rsup|2>|\<mathe\><rsup|2*\<mathe\><rsup|x>+2*x>>>|<cell|>|<cell|P<rsup|\<psi\>>>|<cell|=>|<cell|<frac|Y*\<up-theta\><rsup|2>
      Y-Y*\<up-theta\> Y|x*log<rsup|2> x>-<frac|Y*\<up-theta\> Y|x*log
      x>-<frac|<around*|(|\<up-theta\> Y|)><rsup|2>|x<rsup|2>*log<rsup|2>
      x>>>>>>
    </equation*>
  </hidden>|<\hidden>
    <tit|Differential Newton polynomials>

    <unroll|<\shown>
      We say that <math|\<phi\>> is <strong|active> if
      <math|\<up-delta\>\<assign\>\<phi\><rsup|-1>*\<partial\>> is
      small.<vspace|0.3333fn>
    </shown>|<\shown>
      <\compressed>
        A property for <math|P\<in\>K<around*|{|Y|}>> holds
        <strong|eventually> <math|\<Longleftrightarrow\>>

        It holds for <math|P<rsup|\<phi\>>>, for all sufficiently small
        active <math|\<phi\>><vspace|0.3333fn>
      </compressed>
    </shown>|<\shown>
      Fix a monomial group <math|\<frak-M\>\<subseteq\>K<rsup|\<neq\>0>><space|1em><math|\<Longrightarrow\>><space|1em>dominant
      coefficients well-defined.<vspace|0.25fn>
    </shown>|<\shown>
      <\theorem*>
        Given <math|P\<in\>K<around*|{|Y|}><rsup|\<neq\>0>>, there exists a
        unique <math|N<around*|(|P|)>\<in\>C<around*|{|Y|}>> with
        <math|D<around*|(|P<rsup|\<phi\>>|)>=N<around*|(|P|)>>, eventually.
      </theorem*>
    </shown>|<\shown>
      <\theorem*>
        If <math|K> is <math|\<up-omega\>>-free, then
        <math|N<around*|(|P|)>\<in\>C<around*|[|Y|]>*<around*|(|Y<rprime|'>|)><rsup|<value|NN>>>,
        for all <math|P\<in\>K<around*|{|Y|}>>.
      </theorem*>
    </shown>|<\shown>
      <\eqnarray*>
        <tformat|<cwith|1|1|1|-1|cell-tsep|2spc>|<table|<row|<cell|P>|<cell|=>|<cell|2*Y<rprime|'>*Y<rprime|'''>-3*<around*|(|Y<rprime|''>|)><rsup|2>-\<up-omega\>*<around*|(|Y<rprime|'>|)><rsup|2>>>|<row|<cell|N<around*|(|P|)>>|<cell|=>|<cell|2*Y<rprime|'>*Y<rprime|'''>-3*<around*|(|Y<rprime|''>|)><rsup|2>>>>>
      </eqnarray*>
    </shown>>
  </hidden>|<\hidden>
    <tit|Applications of Newton polynomials>

    (Assuming that <math|K> is <math|\<up-omega\>>-free)

    <equation-lab|P<around*|(|y|)>=0,<space|2em><around*|\<nobracket\>|y\<prec\>\<frak-v\>|\<nobracket\>>|\<star\>>

    \;

    <\overlays-phantoms|4|4>
      <\wide-tabular>
        <tformat|<cwith|2|5|1|-1|cell-tsep|2spc>|<cwith|1|-1|3|3|cell-hpart|1>|<cwith|3|3|1|3|cell-tsep|2spc>|<cwith|3|3|3|3|cell-hpart|1>|<table|<row|<\cell>
          <math|\<frak-m\>\<prec\>\<frak-v\>> starting monomial for
          (\<star\>)
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <math|N<around*|(|P<rsub|\<times\>\<frak-m\>>|)>\<nin\>C*Y<rsup|<value|NN>>>
        </cell>>|<row|<\cell>
          <math|c*\<frak-m\>\<prec\>\<frak-v\>> starting term for (\<star\>)
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <math|N<around*|(|P<rsub|\<times\>\<frak-m\>>|)><around*|(|c|)>=0>
        </cell>>|<row|<\cell>
          <overlay-from|2|Newton degree of (\<star\>)|>
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <overlay-from|2|<math|deg<rsub|\<prec\>\<frak-v\>> P\<assign\>val
          N<around*|(|P<rsub|\<times\>\<frak-v\>>|)>>|>
        </cell>>|<row|<\cell>
          <overlay-from|3|<math|\<frak-m\>> differential starting monomial|>
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <overlay-from|3|<math|N<around*|(|P<rsub|\<times\>\<frak-m\>>|)><rsub|i>\<neq\>0>,<space|1em><math|deg<rsub|\<prec\>\<up-gamma\>>
          R<rsub|P<rsub|i>,+\<frak-m\><rprime|\<dag\>>>\<gtr\>0>|>
        </cell>>|<row|<\cell>
          <overlay-from|4|Usual properties of Newton degree|>
        </cell>|<\cell>
          <space|1em>
        </cell>|<\cell>
          <overlay-from|4|<math|\<varphi\>\<prec\>\<frak-v\><space|1.2spc>\<Longrightarrow\><space|1.2spc>deg<rsub|\<prec\>\<frak-v\>>
          P<rsub|+\<varphi\>>=deg<rsub|\<prec\>\<frak-v\>> P>|>
        </cell>>|<row|<\cell>
          \;
        </cell>|<\cell>
          \;
        </cell>|<\cell>
          <overlay-from|4|<math|\<frak-w\>\<prec\>\<frak-v\><space|1.2spc>\<Longrightarrow\><space|1.2spc>deg<rsub|\<prec\>\<frak-w\>>
          P\<leqslant\>deg<rsub|\<prec\>\<frak-v\>> P>|>
        </cell>>>>
      </wide-tabular>
    </overlays-phantoms>
  </hidden>|<\hidden>
    <tit|The equalizer theorem>

    <unroll|<\shown>
      <math|K> still <math|\<up-omega\>>-free and with a monomial group
      <math|\<frak-M\>\<subseteq\>K<rsup|\<neq\>0>>.
    </shown>|<\shown>
      <\theorem*>
        <\compressed>
          Let <math|P,Q\<in\>K<around*|{|Y|}><rsup|\<neq\>0>> be homogeneous
          of degrees <math|i\<less\>j>.

          Then there exists a unique equalizer
          <math|\<frak-e\>\<in\>\<frak-M\>> such that
          <math|N<around*|(|<around*|(|P+Q|)><rsub|\<times\>\<frak-e\>>|)>>
          is not homogeneous.
        </compressed>
      </theorem*>
    </shown>|<\shown>
      <strong|Proof. >Systematically adopt \Peventual\Q vision.
    </shown>|<\shown>
      As in the transseries case, <math|\<frak-e\>> can be approximated well:

      <\indent>
        <math|P\<sim\>a*Y<rsup|i-i<rprime|'>>*<around*|(|Y<rprime|'>|)><rsup|i<rprime|'>>=a*Y<rsup|i>*<around*|(|Y<rprime|\<dag\>>|)><rsup|i<rprime|'>>>
        and <math|Q\<sim\>b*Y<rsup|j-j<rprime|'>>*<around*|(|Y<rprime|'>|)><rsup|j<rprime|'>>=b*Y<rsup|j>*<around*|(|Y<rprime|\<dag\>>|)><rsup|j<rprime|'>>>
      </indent>

      <\indent>
        <math|\<frak-e\>\<approx\>\<frak-e\><rsub|approx><around*|(|P,Q|)>\<assign\>\<frak-d\><around*|(|<frac|a|b>*<around*|(|a<rprime|\<dag\>>-b<rprime|\<dag\>>|)><rsup|i<rprime|'>-j<rprime|'>>|)><rsup|1/<around*|(|j-i|)>>>
      </indent>
    </shown>|<\shown>
      <\indent>
        <math|\<frak-e\><rsub|0>\<assign\>1>,
        <math|\<frak-e\><rsub|1>\<assign\>\<frak-e\><rsub|approx><around*|(|P<rsub|\<times\>\<frak-e\><rsub|0>>,Q<rsub|\<times\>\<frak-e\><rsub|0>>|)>>,
        <math|\<frak-e\><rsub|2>\<assign\>\<frak-e\><rsub|approx><around*|(|P<rsub|\<times\>\<frak-e\><rsub|1>>,Q<rsub|\<times\>\<frak-e\><rsub|1>>|)>>,
        <math|\<ldots\>>
      </indent>
    </shown>|<\shown>
      <\indent>
        <math|\<frak-e\><rsub|0>/\<frak-e\>\<ggg\>\<frak-e\><rsub|1>/\<frak-e\>\<ggg\>\<frak-e\><rsub|2>/\<frak-e\>\<ggg\>\<cdots\>><space|2em>(<math|\<frak-m\>\<gg\>\<frak-n\>\<Leftrightarrow\>log
        \<frak-m\>\<succsucceq\>\<frak-n\>>)
      </indent>
    </shown>|<\shown>
      However, this is not good enough for convergence in arbitrary
      H-fields<text-dots>
    </shown>>
  </hidden>|<\hidden>
    <tit|The equalizer theorem \V continued proof>

    <unroll|<\shown>
      One remedy: use transfinite induction.
      <tiny-switch|<hidden|>|<shown|Or<text-dots>>>
    </shown>|<\shown>
      <\equation*>
        <tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|5|5|cell-halign|l>|<cwith|1|1|1|-1|cell-bsep|1spc>|<table|<row|<cell|P<rsub|\<times\>\<frak-e\><rsub|0>>>|<cell|\<rightarrow\>>|<cell|P<rsub|\<times\>\<frak-e\><rsub|1>>>|<cell|\<rightarrow\>>|<cell|P<rsub|\<times\>\<frak-e\><rsub|2>>>|<cell|\<rightarrow\>>|<cell|\<cdots\>>>|<row|<cell|R<rsub|P,+\<frak-e\><rsub|0><rprime|\<dag\>>>>|<cell|\<rightarrow\>>|<cell|R<rsub|P,+\<frak-e\><rsub|1><rprime|\<dag\>>>>|<cell|\<rightarrow\>>|<cell|R<rsub|P,+\<frak-e\><rsub|2><rprime|\<dag\>>>>|<cell|\<rightarrow\>>|<cell|\<cdots\>>>>>>\<nocomma\><space|4em><tabular*|<tformat|<cwith|1|-1|1|1|cell-halign|l>|<cwith|1|-1|3|3|cell-halign|l>|<cwith|1|-1|5|5|cell-halign|l>|<cwith|1|1|1|-1|cell-bsep|1spc>|<table|<row|<cell|Q<rsub|\<times\>\<frak-e\><rsub|0>>>|<cell|\<rightarrow\>>|<cell|Q<rsub|\<times\>\<frak-e\><rsub|1>>>|<cell|\<rightarrow\>>|<cell|Q<rsub|\<times\>\<frak-e\><rsub|2>>>|<cell|\<rightarrow\>>|<cell|\<cdots\>>>|<row|<cell|R<rsub|Q,+\<frak-e\><rsub|0><rprime|\<dag\>>>>|<cell|\<rightarrow\>>|<cell|Q<rsub|P,+\<frak-e\><rsub|1><rprime|\<dag\>>>>|<cell|\<rightarrow\>>|<cell|R<rsub|Q,+\<frak-e\><rsub|2><rprime|\<dag\>>>>|<cell|\<rightarrow\>>|<cell|\<cdots\>>>>>>
      </equation*>
    </shown>|<\shown>
      For <math|k\<geqslant\>1>, let <math|d<rsub|k>\<assign\>deg<rsub|\<prec\>\<frak-e\><rsub|k><rprime|\<dag\>>-\<frak-e\><rsub|k-1><rprime|\<dag\>>>
      R<rsub|P,+\<frak-e\><rsub|k><rprime|\<dag\>>>> and
      <math|e<rsub|k>\<assign\>deg<rsub|\<prec\>\<frak-e\><rsub|k><rprime|\<dag\>>-\<frak-e\><rsub|k-1><rprime|\<dag\>>>
      R<rsub|P,+\<frak-e\><rsub|k><rprime|\<dag\>>>>

      We have <math|d<rsub|1>\<geqslant\>d<rsub|2>\<geqslant\>\<cdots\>> and
      <math|e<rsub|1>\<geqslant\>e<rsub|2>\<geqslant\>\<cdots\>>
    </shown>|<\shown>
      We are done whenever <math|d<rsub|k>=e<rsub|k>=0>
    </shown>|<\shown>
      Assume that <math|d=d<rsub|k>=d<rsub|k+1>>,
      <math|e=e<rsub|k>=e<rsub|k+1>=e<rsub|k+2>>, and <math|d+e\<gtr\>0>
    </shown>|<\shown>
      Then <math|R<rsub|P,+\<frak-e\><rsub|l><rprime|\<dag\>>,\<gtr\>d>> and
      <math|R<rsub|Q,+\<frak-e\><rsub|l><rprime|\<dag\>>,\<gtr\>e>> are
      \Pnegligible\Q for <math|l\<geqslant\>k+1>
    </shown>|<\shown>
      In particular, <math|R<rsub|P,+\<frak-e\><rsub|k+2><rprime|\<dag\>>,d>\<sim\>R<rsub|P,+\<frak-e\><rsub|k+1><rprime|\<dag\>>,d>>
      and <math|R<rsub|Q,+\<frak-e\><rsub|k+2><rprime|\<dag\>>,d>\<sim\>R<rsub|Q,+\<frak-e\><rsub|k+1><rprime|\<dag\>>,d>>
    </shown>|<\shown>
      Take <math|\<frak-e\><rsub|k+2>\<assign\><around*|(|\<frak-d\><around*|(|R<rsub|P,+\<frak-e\><rsub|k+1><rprime|\<dag\>>>|)>/\<frak-d\><around*|(|R<rsub|Q,+\<frak-e\><rsub|k+1><rprime|\<dag\>>>|)>|)><rsup|1/<around*|(|j-i|)>>>
      instead of <math|\<frak-e\><rsub|k+2>\<assign\>\<frak-e\><rsub|approx><around*|(|P<rsub|\<times\>\<frak-e\><rsub|k+1>>,Q<rsub|\<times\>\<frak-e\><rsub|k+1>>|)>>

      <\indent>
        This ensures that <math|d<rsub|k+2>\<less\>d<rsub|k+1>> or
        <math|e<rsub|k+2>\<less\>e<rsub|k+1>>.<htab|5mm><qed>
      </indent>
    </shown>>
  </hidden>|<\hidden>
    <tit|Quasi-linear equations>

    <unroll|<\shown>
      <\definition*>
        The H-field <math|K> is said to be <strong|newtonian> if every
        quasi-linear equation has a solution.
      </definition*>
    </shown>|<\shown>
      <\theorem*>
        Let <math|K> be an ungrounded <math|\<up-omega\>>-free H-field with
        divisible <math|\<Gamma\>> and real closed <math|C>. Then there
        exists a newtonian extension <math|K<rsup|\<up-n\>>\<supseteq\>K>
        which embeds over <math|K> into any newtonian
        extension<nbsp>of<nbsp><math|K>. This extension
        <math|K<rsup|\<up-n\>>\<supseteq\>K> is immediate, differentially
        algebraic, and <math|K<rsup|\<up-n\>>> is <math|\<up-omega\>>-free.
        We call it the <strong|newtonization><nbsp>of<nbsp><math|K>.
      </theorem*>
    </shown>|<\shown>
      <\corollary*>
        Let <math|K> be an ungrounded <math|\<up-omega\>>-free H-field with
        divisible <math|\<Gamma\>> and real closed <math|C>. Then there
        exists a newtonian Liouville closed extension
        <math|K<rsup|nl>\<supseteq\>K> which embeds over <math|K> into any
        newtonian Liouville closed extension of <math|K>. This extension
        <math|K<rsup|nl>\<supseteq\>K> is differentially algebraic,
        <math|\<up-omega\>>-free, and we have <math|C<rsub|K<rsup|nl>>=C>. We
        call <math|K<rsup|nl>> the <strong|Newton-Liouville
        closure><nbsp>of<nbsp><math|K>.
      </corollary*>
    </shown>>
  </hidden>|<\hidden>
    <tit|Unravelling>

    <unroll|<\shown>
      <math|K> is <math|\<up-omega\>>-free, with a divisible monomial group
      <math|\<frak-M\>\<subseteq\>K<rsup|\<neq\>0>> and small derivation.
    </shown>|<\shown>
      <\theorem*>
        Any asymptotic differential equation over <math|K> can be unravelled.
      </theorem*>
    </shown>|<\shown>
      <vspace*|0.5fn><math|K> is <strong|asymptotically d-algebraically
      maximal><space|1em><math|\<Longleftrightarrow\>>

      There exists no proper immediate d-algebraic H-field extension of
      <math|K><vspace|0.5fn>
    </shown>|<\shown>
      <\corollary*>
        If <math|K> is newtonian, then <math|K> is asymptotically
        d-algebraically maximal.
      </corollary*>
    </shown>>
  </hidden>>
</body>

<\initial>
  <\collection>
    <associate|eqn-long-above|<macro|0fn>>
    <associate|eqn-long-below|<macro|0fn>>
    <associate|eqn-short-above|<macro|0fn>>
    <associate|eqn-short-below|<macro|0fn>>
    <associate|font|cal=termes,TeX Gyre Pagella>
    <associate|font-base-size|9>
    <associate|font-family|rm>
    <associate|info-flag|none>
    <associate|magnification|2>
    <associate|math-font|math-pagella>
    <associate|page-bot|-5mm>
    <associate|page-height|auto>
    <associate|page-medium|beamer>
    <associate|page-type|16:9>
    <associate|page-width|auto>
    <associate|par-par-sep|0.25fn>
    <associate|strong-color|dark magenta>
    <associate|title-shadow-font-color|dark red>
    <associate|title-sunny-font-color|#a66>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|auto-1|<tuple|1|?>>
    <associate|auto-2|<tuple|2|?>>
    <associate|auto-3|<tuple|3|?>>
    <associate|auto-4|<tuple|4|?>>
    <associate|auto-5|<tuple|5|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|toc>
      <with|par-left|<quote|4tab>|Hardy fields.
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-1><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|Transseries.
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-2><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|<with|color|<quote|#483030>|font-family|<quote|rm>|<with|mode|<quote|math>|\<up-gamma\>>>-freeness
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|<with|color|<quote|#483030>|font-family|<quote|rm>|<with|mode|<quote|math>|\<up-lambda\>>>-freeness
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-4><vspace|0.15fn>>

      <with|par-left|<quote|4tab>|<with|color|<quote|#483030>|font-family|<quote|rm>|<with|mode|<quote|math>|\<up-omega\>>>-freeness
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-5><vspace|0.15fn>>
    </associate>
  </collection>
</auxiliary>